/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.util.internal.URLUtil;
import com.liferay.faces.util.render.FacesURLEncoder;
import com.liferay.faces.util.render.FacesURLEncoderFactory;
import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class ResponseWriterResourceImpl
extends ResponseWriterWrapper {
    private final FacesURLEncoder facesURLEncoder;
    private final ResponseWriter wrappedResponseWriter;
    private Attribute javaScriptType;
    private boolean writingLink;
    private boolean writingScript;
    private boolean closeStartTag;

    public ResponseWriterResourceImpl(FacesContext facesContext, ResponseWriter responseWriter) {
        ExternalContext externalContext = facesContext.getExternalContext();
        this.facesURLEncoder = FacesURLEncoderFactory.getFacesURLEncoderInstance((ExternalContext)externalContext);
        this.wrappedResponseWriter = responseWriter;
    }

    public Writer append(char c) throws IOException {
        this.closeStartTagIfNecessary();
        return super.append(c);
    }

    public Writer append(CharSequence csq) throws IOException {
        this.closeStartTagIfNecessary();
        return super.append(csq);
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.closeStartTagIfNecessary();
        return super.append(csq, start, end);
    }

    public void close() throws IOException {
        this.closeStartTagIfNecessary();
        super.close();
    }

    public void endCDATA() throws IOException {
        this.closeStartTagIfNecessary();
        super.endCDATA();
    }

    public void endDocument() throws IOException {
        this.closeStartTagIfNecessary();
        super.endDocument();
    }

    public void endElement(String name) throws IOException {
        boolean endingScript = "script".equalsIgnoreCase(name);
        boolean endingLink = "link".equalsIgnoreCase(name);
        if (endingScript || endingLink) {
            this.closeStartTagIfNecessary();
            this.writeWithoutClosingStartTag("</");
            this.writeWithoutClosingStartTag(name);
            this.writeWithoutClosingStartTag(">");
            if (endingScript) {
                this.writingScript = false;
            } else {
                this.writingLink = false;
            }
        } else {
            super.endElement(name);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startCDATA() throws IOException {
        this.closeStartTagIfNecessary();
        super.startCDATA();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.writingScript = "script".equalsIgnoreCase(name);
        this.writingLink = "link".equalsIgnoreCase(name);
        if (this.writingScript || this.writingLink) {
            this.writeWithoutClosingStartTag("<");
            this.writeWithoutClosingStartTag(name);
            this.closeStartTag = true;
        } else {
            super.startElement(name, component);
        }
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        super.write(str);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        super.write(cbuf);
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        super.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        super.write(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        super.write(str, off, len);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.writingScript && "type".equalsIgnoreCase(name) && "text/javascript".equalsIgnoreCase((String)value)) {
            this.javaScriptType = new Attribute(name, value);
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeComment(Object comment) throws IOException {
        this.closeStartTagIfNecessary();
        super.writeComment(comment);
    }

    public void writeText(Object text, String property) throws IOException {
        this.closeStartTagIfNecessary();
        super.writeText(text, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        super.writeText(text, off, len);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.closeStartTagIfNecessary();
        super.writeText(text, component, property);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.writingScript || this.writingLink) {
            this.writeWithoutClosingStartTag(" ");
            this.writeWithoutClosingStartTag(name);
            this.writeWithoutClosingStartTag("=\"");
            if (value != null) {
                String uri = value.toString();
                String characterEncoding = this.wrappedResponseWriter.getCharacterEncoding();
                uri = URLUtil.encodeURL(uri, this.facesURLEncoder, characterEncoding);
                this.writeWithoutClosingStartTag(uri);
            }
            this.writeWithoutClosingStartTag("\"");
        }
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this.closeStartTag && (this.writingScript || this.writingLink)) {
            this.closeStartTag = false;
            if (this.javaScriptType != null) {
                this.writeWithoutClosingStartTag(" ");
                this.writeWithoutClosingStartTag(this.javaScriptType.name);
                this.writeWithoutClosingStartTag("=\"");
                if (this.javaScriptType.value != null) {
                    this.writeWithoutClosingStartTag(this.javaScriptType.value.toString());
                }
                this.writeWithoutClosingStartTag("\"");
                this.javaScriptType = null;
            }
            this.writeWithoutClosingStartTag(">");
        }
    }

    private void writeWithoutClosingStartTag(String string) throws IOException {
        boolean closeStartTag = this.closeStartTag;
        this.closeStartTag = false;
        super.write(string);
        this.closeStartTag = closeStartTag;
    }

    private static final class Attribute {
        private final String name;
        private final Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

