/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.application.internal.BridgeNavigationUtil;
import com.liferay.faces.bridge.context.internal.ExternalContextCompat_Portlet3_Impl;
import com.liferay.faces.bridge.context.internal.FacesView;
import com.liferay.faces.bridge.context.internal.FacesViewImpl;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderValuesMap;
import com.liferay.faces.bridge.filter.internal.HttpServletResponseRenderAdapter;
import com.liferay.faces.bridge.filter.internal.HttpServletResponseResourceAdapter;
import com.liferay.faces.bridge.internal.BridgePhaseHeaderRenderCommon;
import com.liferay.faces.bridge.internal.BridgeURI;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.util.internal.LocaleIterator;
import com.liferay.faces.bridge.util.internal.URLUtil;
import com.liferay.faces.bridge.util.internal.ViewUtil;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import com.liferay.faces.util.render.FacesURLEncoder;
import com.liferay.faces.util.render.FacesURLEncoderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeInvalidViewPathException;
import javax.servlet.http.HttpServletResponse;

public class ExternalContextImpl
extends ExternalContextCompat_Portlet3_Impl {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextImpl.class);
    private static final String ORG_RICHFACES_EXTENSION = "org.richfaces.extension";
    private static final String REQUEST_ATTR_PORTLET_REQUEST = "javax.portlet.request";
    private static final String REQUEST_ATTR_QUERY_STRING = "javax.servlet.forward.query_string";
    private Map<String, Object> applicationMap;
    private ContextMapFactory contextMapFactory;
    private Map<String, Object> requestAttributeMap;
    private String requestContextPath;
    private Map<String, Object> sessionMap;
    private String authType;
    private String defaultRenderKitId;
    private Map<String, String> defaultViewIdMap;
    private FacesView facesView;
    private Map<String, String> initParameterMap;
    private String remoteUser;
    private Map<String, Object> requestCookieMap;
    private Locale requestLocale;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Map<String, String> requestParameterMap;
    private Map<String, String[]> requestParameterValuesMap;
    private StringWrapper requestPathInfo;
    private String requestServletPath;
    private Principal userPrincipal;
    private String viewIdAndQueryString;

    public ExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(portletContext, portletRequest, portletResponse);
        this.contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ContextMapFactory.class);
        this.preInitializeObjects();
        logger.debug("User-Agent requested URL=[{0}]", new Object[]{this.getRequestURL()});
    }

    public void dispatch(String path) throws IOException {
        block7: {
            logger.debug("Acquiring dispatcher for JSP path=[{0}]", new Object[]{path});
            PortletRequestDispatcher portletRequestDispacher = this.portletContext.getRequestDispatcher(path);
            try {
                if (portletRequestDispacher != null) {
                    Boolean renderRedirectAfterDispatch = (Boolean)this.portletRequest.getAttribute("com.liferay.faces.bridge.renderRedirectAfterDispatch");
                    if (renderRedirectAfterDispatch != null && renderRedirectAfterDispatch.booleanValue()) {
                        portletRequestDispacher.include(this.portletRequest, this.portletResponse);
                    } else if (this.portletPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
                        portletRequestDispacher.include(this.portletRequest, this.portletResponse);
                    } else {
                        portletRequestDispacher.forward(this.portletRequest, this.portletResponse);
                    }
                    break block7;
                }
                throw new IOException("Unable to acquire PortletRequestDispatcher for path=[" + path + "]");
            }
            catch (PortletException e) {
                logger.error((Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
    }

    public String encodeActionURL(String url) {
        if (this.isEncodingFormWithPrimeFacesAjaxFileUpload()) {
            return this.encodePartialActionURL(url);
        }
        if (url == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL bridgeActionURL = this.bridgeURLFactory.getBridgeActionURL(facesContext, url);
            return bridgeActionURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeNamespace(String name) {
        Product RICHFACES = ProductFactory.getProductInstance((ExternalContext)this, (Product.Name)Product.Name.RICHFACES);
        boolean RICHFACES_DETECTED = RICHFACES.isDetected();
        if (name == null) {
            return this.portletResponse.getNamespace();
        }
        if (RICHFACES_DETECTED && name.equals(ORG_RICHFACES_EXTENSION)) {
            return name;
        }
        return this.portletResponse.getNamespace() + name;
    }

    public String encodeResourceURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL encodedResourceURL = this.bridgeURLFactory.getBridgeResourceURL(facesContext, url);
            return encodedResourceURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Map<String, Object> getApplicationMap() {
        return this.applicationMap;
    }

    public String getAuthType() {
        if (this.authType == null) {
            this.authType = this.portletRequest.getAuthType();
        }
        return this.authType;
    }

    public Object getContext() {
        return this.portletContext;
    }

    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (initParameter == null) {
            initParameter = this.portletContext.getInitParameter(name);
        }
        return initParameter;
    }

    public Map<String, String> getInitParameterMap() {
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.portletRequest.getRemoteUser();
        }
        return this.remoteUser;
    }

    public Object getRequest() {
        return this.portletRequest;
    }

    public String getRequestCharacterEncoding() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            String requestCharacterEncoding = clientDataRequest.getCharacterEncoding();
            if (this.manageIncongruities) {
                try {
                    this.incongruityContext.setRequestCharacterEncoding(requestCharacterEncoding);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            return requestCharacterEncoding;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getRequestCharacterEncoding();
        }
        return null;
    }

    public String getRequestContentType() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            String requestContentType = this.isICEfacesLegacyMode(clientDataRequest) ? clientDataRequest.getResponseContentType() : clientDataRequest.getContentType();
            if (this.manageIncongruities) {
                this.incongruityContext.setRequestContentType(requestContentType);
            }
            return requestContentType;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getRequestContentType();
        }
        return null;
    }

    public String getRequestContextPath() {
        return this.requestContextPath;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this.requestCookieMap == null) {
            this.requestCookieMap = this.contextMapFactory.getRequestCookieMap(this.portletRequest);
        }
        return this.requestCookieMap;
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap(this.getRequestHeaderValuesMap()));
        }
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap(this.portletRequest));
        }
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        if (this.requestLocale == null) {
            this.requestLocale = this.portletRequest.getLocale();
        }
        return this.requestLocale;
    }

    public Iterator<Locale> getRequestLocales() {
        return new LocaleIterator(this.portletRequest.getLocales());
    }

    public Map<String, Object> getRequestMap() {
        return this.requestAttributeMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            PortletRequest portletRequest = (PortletRequest)this.getRequest();
            PortletResponse portletResponse = (PortletResponse)this.getResponse();
            String responseNamespace = portletResponse.getNamespace();
            String facesViewQueryString = null;
            FacesView facesView = this.getFacesView();
            if (facesView != null) {
                facesViewQueryString = facesView.getQueryString();
            }
            this.requestParameterMap = this.contextMapFactory.getRequestParameterMap(portletRequest, responseNamespace, this.portletConfig, this.bridgeRequestScope, this.defaultRenderKitId, facesViewQueryString);
        }
        return this.requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return this.getRequestParameterMap().keySet().iterator();
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            PortletRequest portletRequest = (PortletRequest)this.getRequest();
            PortletResponse portletResponse = (PortletResponse)this.getResponse();
            String responseNamespace = portletResponse.getNamespace();
            String facesViewQueryString = this.getFacesView().getQueryString();
            this.requestParameterValuesMap = this.contextMapFactory.getRequestParameterValuesMap(portletRequest, responseNamespace, this.portletConfig, this.bridgeRequestScope, this.defaultRenderKitId, facesViewQueryString);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        String returnValue = null;
        if (this.requestPathInfo == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                logger.debug("requestPathInfo=[null] EXTENSION=[{1}] viewId=[{2}]", new Object[]{facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                returnValue = viewId.substring(facesView.getServletPath().length());
                logger.debug("requestPathInfo=[{0}] PATH=[{1}] viewId=[{2}]", new Object[]{returnValue, facesView.getServletPath(), viewId});
            } else {
                returnValue = facesView.getViewId();
                logger.debug("requestPathInfo=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{returnValue, viewId});
            }
            this.requestPathInfo = new StringWrapper(returnValue);
        } else {
            returnValue = this.requestPathInfo.getValue();
        }
        return returnValue;
    }

    public String getRequestServletPath() {
        if (this.requestServletPath == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                this.requestServletPath = facesView.getViewId();
                logger.debug("requestServletPath=[{0}] extensionMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                this.requestServletPath = facesView.getViewId();
                int pos = this.requestServletPath.lastIndexOf("/*");
                if (pos >= 0) {
                    this.requestServletPath = this.requestServletPath.substring(0, pos);
                }
                logger.debug("requestServletPath=[{0}] pathMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getServletPath(), viewId});
            } else {
                this.requestServletPath = "";
                logger.debug("requestServletPath=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{this.requestServletPath, viewId});
            }
        }
        return this.requestServletPath;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.portletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.portletResponse;
    }

    public String getResponseCharacterEncoding() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            String characterEncoding = mimeResponse.getCharacterEncoding();
            if (this.manageIncongruities) {
                this.incongruityContext.setResponseCharacterEncoding(characterEncoding);
            }
            return characterEncoding;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getResponseCharacterEncoding();
        }
        if (this.portletResponse instanceof StateAwareResponse) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            String characterEncoding = (String)externalContext.getRequestMap().get("com.liferay.faces.bridge.responseCharacterEncoding");
            if (characterEncoding != null) {
                return characterEncoding;
            }
            throw new IllegalStateException();
        }
        return null;
    }

    public String getResponseContentType() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            String responseContentType = mimeResponse.getContentType();
            if (responseContentType == null) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                responseContentType = this.isJSF2PartialRequest(facesContext) ? "text/xml" : this.portletRequest.getResponseContentType();
            }
            return responseContentType;
        }
        throw new IllegalStateException();
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Map<String, Object> getSessionMap() {
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null) {
            this.userPrincipal = this.portletRequest.getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public void log(String message) {
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        this.portletContext.log(message, exception);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void redirect(String url) throws IOException {
        if (url != null) {
            logger.debug("redirect url=[{0}]", new Object[]{url});
            if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE || this.isHeaderPhase(this.portletPhase) || this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                try {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    ExternalContext externalContext = facesContext.getExternalContext();
                    FacesURLEncoder facesURLEncoder = FacesURLEncoderFactory.getFacesURLEncoderInstance((ExternalContext)externalContext);
                    ResponseWriter responseWriter = facesContext.getResponseWriter();
                    String urlCharacterEncoding = URLUtil.getURLCharacterEncoding(this.portletPhase, externalContext, responseWriter, "UTF-8");
                    BridgeURI bridgeURI = new BridgeURI(url, this.portletResponse.getNamespace(), facesURLEncoder, urlCharacterEncoding);
                    String directLink = bridgeURI.getParameter("javax.portlet.faces.DirectLink");
                    String contextPath = externalContext.getRequestContextPath();
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE && (url.startsWith("#") || bridgeURI.isExternal(contextPath) || "true".equals(directLink))) {
                        if (this.bridgeRequestScope != null) {
                            this.bridgeRequestScope.setRedirectOccurred(true);
                        }
                        ActionResponse actionResponse = (ActionResponse)this.portletResponse;
                        actionResponse.sendRedirect(bridgeURI.toString());
                        return;
                    }
                    PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                    PortalContext portalContext = portletRequest.getPortalContext();
                    String createRenderUrlDuringActionPhaseSupport = portalContext.getProperty("com.liferay.faces.bridge.create.render.url.during.action.phase.support");
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE && createRenderUrlDuringActionPhaseSupport != null) {
                        BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(facesContext, bridgeURI.toString(), null);
                        ActionResponse actionResponse = (ActionResponse)this.portletResponse;
                        actionResponse.sendRedirect(bridgeRedirectURL.toString());
                        return;
                    }
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE) {
                        String newViewId = bridgeURI.getContextRelativePath(contextPath);
                        UIViewRoot viewRoot = facesContext.getViewRoot();
                        String currentFacesViewId = viewRoot.getViewId();
                        if (!currentFacesViewId.equals(newViewId)) {
                            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                            UIViewRoot newViewRoot = viewHandler.createView(facesContext, newViewId);
                            facesContext.setViewRoot(newViewRoot);
                        }
                        bridgeURI.setParameter(this.bridgeConfig.getViewIdRenderParameterName(), newViewId);
                        this.partialViewContextRenderAll(facesContext);
                        facesContext.responseComplete();
                        if (this.bridgeRequestScope != null) {
                            this.bridgeRequestScope.setRedirectOccurred(true);
                        }
                        try {
                            StateAwareResponse stateAwareResponse = (StateAwareResponse)this.portletResponse;
                            BridgeNavigationUtil.navigate(portletRequest, stateAwareResponse, bridgeURI.getParameterMap());
                            return;
                        }
                        catch (PortletException e) {
                            logger.error(e.getMessage());
                        }
                        return;
                    }
                    if (!this.isHeaderPhase(this.portletPhase) && this.portletPhase != Bridge.PortletPhase.RENDER_PHASE) return;
                    BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(facesContext, url, null);
                    String redirectURLViewId = bridgeRedirectURL.getViewId();
                    if (redirectURLViewId != null) {
                        portletRequest.setAttribute("com.liferay.faces.bridge.renderRedirect", (Object)Boolean.TRUE);
                        portletRequest.setAttribute("com.liferay.faces.bridge.renderRedirectViewId", (Object)redirectURLViewId);
                        return;
                    }
                    String viewIdRenderParameterName = this.bridgeConfig.getViewIdRenderParameterName();
                    String viewIdRenderParameterValue = bridgeRedirectURL.getParameter(viewIdRenderParameterName);
                    if (viewIdRenderParameterValue == null) {
                        Map requestMap = externalContext.getRequestMap();
                        String requestMapKey = "javax.portlet.faces.viewId" + url;
                        viewIdRenderParameterValue = (String)requestMap.remove(requestMapKey);
                    }
                    if (viewIdRenderParameterValue == null) throw new IllegalStateException("6.1.3.1: Unable to redirect to a non-Faces view during the RENDER_PHASE.");
                    portletRequest.setAttribute("com.liferay.faces.bridge.renderRedirect", (Object)Boolean.TRUE);
                    portletRequest.setAttribute("com.liferay.faces.bridge.renderRedirectViewId", (Object)viewIdRenderParameterValue);
                    return;
                }
                catch (URISyntaxException e) {
                    logger.error((Throwable)e);
                }
                return;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!this.isJSF2PartialRequest(facesContext)) throw new UnsupportedEncodingException("Can only redirect during RESOURCE_PHASE if a JSF partial/Ajax request has been triggered");
            try {
                this.redirectJSF2PartialResponse(facesContext, (ResourceResponse)this.portletResponse, url);
                return;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
        logger.error("redirect url=null");
    }

    public void setRequest(Object request) {
        if (request == null || !(request instanceof PortletRequest)) {
            throw new IllegalArgumentException("Must be an instance of javax.portlet.PortletRequest");
        }
        this.portletRequest = (PortletRequest)request;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.preInitializeObjects();
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException, IllegalStateException {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            try {
                clientDataRequest.setCharacterEncoding(encoding);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this.manageIncongruities) {
            this.incongruityContext.setRequestCharacterEncoding(encoding);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResponse(Object response) {
        if (response == null) throw new IllegalArgumentException("response cannot be null");
        if (response instanceof PortletResponse) {
            this.portletResponse = (PortletResponse)response;
            this.preInitializeObjects();
            return;
        } else {
            if (!(response instanceof HttpServletResponse)) throw new IllegalArgumentException("response=[" + response + "] is not an instance of javax.portlet.PortletResponse");
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                this.portletResponse = new HttpServletResponseRenderAdapter((RenderResponse)this.portletResponse, httpServletResponse);
            } else {
                if (this.portletPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new IllegalArgumentException("Unable to decorate httpServletResponse=[" + response + "] in phase=[" + this.portletPhase + "]");
                this.portletResponse = new HttpServletResponseResourceAdapter((ResourceResponse)this.portletResponse, httpServletResponse);
            }
            this.preInitializeObjects();
        }
    }

    public void setResponseCharacterEncoding(String encoding) {
        if (encoding != null) {
            if (this.portletResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
                resourceResponse.setCharacterEncoding(encoding);
            } else if (this.manageIncongruities) {
                this.incongruityContext.setResponseCharacterEncoding(encoding);
            }
        }
    }

    protected BridgeConfig getBridgeConfig() {
        return (BridgeConfig)this.getRequestMap().get(BridgeConfig.class.getName());
    }

    protected Map<String, String> getDefaultViewIdMap(PortletConfig portletConfig) {
        if (this.defaultViewIdMap == null) {
            this.defaultViewIdMap = ViewUtil.getDefaultViewIdMap(portletConfig);
        }
        return this.defaultViewIdMap;
    }

    protected FacesView getFacesView() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.facesView == null) {
            if (BridgePhaseHeaderRenderCommon.isHandlingBridgeInvalidViewPathException(this.portletRequest)) {
                this.facesView = new FacesViewImpl(null, Collections.emptyList(), Collections.emptyList());
            } else {
                String fullViewId = this.getFacesViewIdAndQueryString();
                String viewId = null;
                String navigationQueryString = null;
                if (fullViewId != null) {
                    int pos = fullViewId.indexOf("?");
                    if (pos > 0) {
                        navigationQueryString = fullViewId.substring(pos + 1);
                        viewId = fullViewId.substring(0, pos);
                    } else {
                        viewId = fullViewId;
                    }
                }
                this.facesView = new FacesViewImpl(viewId, navigationQueryString, this.configuredSuffixes, this.configuredFacesServletMappings);
            }
        }
        return this.facesView;
    }

    protected String getFacesViewIdAndQueryString() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.viewIdAndQueryString == null) {
            this.viewIdAndQueryString = this.getFacesViewIdRequestAttribute("javax.portlet.faces.viewId");
            if (this.viewIdAndQueryString == null) {
                String viewPath = this.getFacesViewIdRequestAttribute("javax.portlet.faces.viewPath");
                if (viewPath != null) {
                    String contextPath;
                    int pos = viewPath.indexOf("?");
                    if (pos > 0) {
                        viewPath = viewPath.substring(0, pos);
                    }
                    if ((pos = viewPath.indexOf(contextPath = this.portletRequest.getContextPath())) >= 0) {
                        viewPath = viewPath.substring(pos + contextPath.length());
                    }
                    if (!viewPath.startsWith("/")) {
                        viewPath = "/" + viewPath;
                    }
                    this.viewIdAndQueryString = this.getFacesViewIdFromPath(viewPath);
                    if (this.viewIdAndQueryString == null) {
                        throw new BridgeInvalidViewPathException();
                    }
                }
                if (this.viewIdAndQueryString == null) {
                    String renderRedirectViewId = (String)this.portletRequest.getAttribute("com.liferay.faces.bridge.renderRedirectViewId");
                    if (renderRedirectViewId != null) {
                        this.viewIdAndQueryString = renderRedirectViewId;
                    }
                    if (this.viewIdAndQueryString == null) {
                        String requestParameterName = this.portletPhase == Bridge.PortletPhase.RESOURCE_PHASE ? this.bridgeConfig.getViewIdResourceParameterName() : this.bridgeConfig.getViewIdRenderParameterName();
                        this.viewIdAndQueryString = this.getFacesViewIdRequestParameter(requestParameterName);
                        if (this.viewIdAndQueryString == null) {
                            PortletMode currentPortletMode = this.portletRequest.getPortletMode();
                            if (currentPortletMode == null) {
                                logger.debug("Unable to get the default view for portletMode=undefined");
                            } else {
                                this.viewIdAndQueryString = this.getDefaultViewIdMap(this.portletConfig).get(currentPortletMode.toString());
                                logger.debug("portlet.xml viewId=[{0}] portletMode=[{1}]", new Object[]{this.viewIdAndQueryString, currentPortletMode});
                                if (this.viewIdAndQueryString == null) {
                                    throw new BridgeDefaultViewNotSpecifiedException();
                                }
                            }
                        } else {
                            logger.debug("request parameter {0}=[{1}]", new Object[]{requestParameterName, this.viewIdAndQueryString});
                        }
                    } else {
                        logger.debug("redirect viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
                    }
                }
            } else {
                logger.debug("javax.portlet.faces.viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
            }
        }
        if (this.viewIdAndQueryString != null && !this.viewIdAndQueryString.startsWith("/")) {
            this.viewIdAndQueryString = "/" + this.viewIdAndQueryString;
        }
        return this.viewIdAndQueryString;
    }

    protected String getFacesViewIdFromPath(String viewPath) {
        String facesViewId = null;
        for (ConfiguredServletMapping configuredFacesServletMapping : this.configuredFacesServletMappings) {
            logger.debug("Attempting to determine the facesViewId from {0}=[{1}]", new Object[]{"javax.portlet.faces.viewPath", viewPath});
            if (!configuredFacesServletMapping.isMatch(viewPath)) continue;
            if (configuredFacesServletMapping.isExtensionMapped()) {
                for (String defaultSuffix : this.configuredSuffixes) {
                    int pos = viewPath.lastIndexOf(".");
                    if (pos <= 0) continue;
                    String resourcePath = viewPath.substring(0, pos) + defaultSuffix;
                    try {
                        URL resourceURL = this.portletContext.getResource(resourcePath);
                        if (resourceURL == null) continue;
                        facesViewId = viewPath;
                        break;
                    }
                    catch (MalformedURLException e) {
                        logger.error((Throwable)e);
                    }
                }
                if (facesViewId == null) {
                    logger.error("Matched EXTENSION MAPPING for for urlPattern=[{0}] and viewPath=[{1}] but unable to find a facesViewId with extensions[{2}]", new Object[]{configuredFacesServletMapping.getUrlPattern(), viewPath, this.configuredSuffixes});
                }
            } else if (configuredFacesServletMapping.isPathMapped()) {
                facesViewId = viewPath;
            }
            if (facesViewId == null) continue;
            break;
        }
        return facesViewId;
    }

    protected String getFacesViewIdRequestAttribute(String name) {
        String value = (String)this.portletRequest.getAttribute(name);
        if (value != null && (value.contains(":") || value.contains("%3A") || value.contains("%253A"))) {
            logger.warn("Invalid character in request attribute {0}=[{1}]", new Object[]{name, value});
            value = null;
        }
        return value;
    }

    protected String getFacesViewIdRequestParameter(String name) {
        String value = this.portletRequest.getParameter(name);
        if (value != null && (value.contains(":") || value.contains("%3A") || value.contains("%253A"))) {
            logger.warn("Invalid character in request parameter {0}=[{1}]", new Object[]{name, value});
            value = null;
        }
        return value;
    }

    protected String getRequestQueryString(PortletRequest portletRequest) {
        Object portletRequestAsObject;
        String requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
        if (requestQueryString == null && (portletRequestAsObject = portletRequest.getAttribute(REQUEST_ATTR_PORTLET_REQUEST)) != null && portletRequestAsObject instanceof PortletRequest) {
            portletRequest = (PortletRequest)portletRequestAsObject;
            requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
        }
        return requestQueryString;
    }

    protected String getRequestURL() {
        return this.portletRequest.getScheme() + "://" + this.portletRequest.getServerName() + ":" + this.portletRequest.getServerPort() + this.portletRequest.getContextPath() + "?" + this.getRequestQueryString(this.portletRequest);
    }

    protected void preInitializeObjects() {
        this.portletPhase = (Bridge.PortletPhase)this.portletRequest.getAttribute("javax.portlet.faces.phase");
        boolean preferPreDestroy = PortletConfigParam.PreferPreDestroy.getBooleanValue(this.portletConfig);
        this.applicationMap = this.contextMapFactory.getApplicationScopeMap(this.portletContext, preferPreDestroy);
        this.requestAttributeMap = this.contextMapFactory.getRequestScopeMap(this.portletContext, this.portletRequest, this.portletResponse.getNamespace(), preferPreDestroy);
        this.sessionMap = this.contextMapFactory.getSessionScopeMap(this.portletContext, this.portletRequest.getPortletSession(true), 2, preferPreDestroy);
        this.initParameterMap = this.contextMapFactory.getInitParameterMap(this.portletConfig);
        this.requestContextPath = this.portletRequest.getContextPath();
        String attributeName = "javax.portlet.faces." + this.portletConfig.getPortletName() + "." + "defaultRenderKitId";
        this.defaultRenderKitId = (String)this.portletContext.getAttribute(attributeName);
        if (this.defaultRenderKitId == null) {
            this.defaultRenderKitId = PortletConfigParam.DefaultRenderKitId.getStringValue(this.portletConfig);
        }
    }

    private static final class StringWrapper {
        private String value;

        public StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

