/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.annotation.BridgeRequestScopeAttributeAdded;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;

public class BridgeRequestAttributeListener
implements ServletRequestAttributeListener {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestAttributeListener.class);

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        ServletRequest servletRequest = servletRequestAttributeEvent.getServletRequest();
        Bridge.PortletPhase phase = (Bridge.PortletPhase)servletRequest.getAttribute("javax.portlet.faces.phase");
        if (phase != null && phase != Bridge.PortletPhase.RENDER_PHASE) {
            String attributeName = servletRequestAttributeEvent.getName();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BridgeConfig bridgeConfig = RequestMapUtil.getBridgeConfig(facesContext);
            Set excludedRequestScopeAttributes = bridgeConfig.getExcludedRequestAttributes();
            if (!excludedRequestScopeAttributes.contains(attributeName)) {
                Method[] methods;
                Object attributeValue = servletRequestAttributeEvent.getValue();
                logger.trace("Attribute added name=[{0}] value=[{1}]", new Object[]{attributeName, attributeValue});
                if (attributeValue != null && (methods = attributeValue.getClass().getMethods()) != null) {
                    for (Method method : methods) {
                        if (method == null || !method.isAnnotationPresent(BridgeRequestScopeAttributeAdded.class)) continue;
                        try {
                            method.invoke(attributeValue, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        String attributeName = servletRequestAttributeEvent.getName();
        Object attributeValue = servletRequestAttributeEvent.getValue();
        logger.trace("Attribute removed name=[{0}] value=[{1}]", new Object[]{attributeName, attributeValue});
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        String attributeName = servletRequestAttributeEvent.getName();
        Object attributeValue = servletRequestAttributeEvent.getValue();
        logger.trace("Attribute replaced name=[{0}] value=[{1}]", new Object[]{attributeName, attributeValue});
    }
}

