/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeConfigFactory;
import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.filter.BridgePortletConfigFactory;
import com.liferay.faces.bridge.internal.BridgeCompatImpl;
import com.liferay.faces.bridge.internal.BridgePhaseActionImpl;
import com.liferay.faces.bridge.internal.BridgePhaseEventImpl;
import com.liferay.faces.bridge.internal.BridgePhaseRenderImpl;
import com.liferay.faces.bridge.internal.BridgePhaseResourceImpl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeNotAFacesRequestException;
import javax.portlet.faces.BridgeUninitializedException;

public class BridgeImpl
extends BridgeCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgeImpl.class);
    private boolean initialized;
    private PortletConfig portletConfig;

    public void destroy() {
        this.initialized = false;
        try {
            PortletContext portletContext = this.portletConfig.getPortletContext();
            BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BridgeRequestScopeManagerFactory.class);
            if (bridgeRequestScopeManagerFactory != null) {
                BridgeRequestScopeManager bridgeRequestScopeManager = bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager(portletContext);
                bridgeRequestScopeManager.removeBridgeRequestScopesByPortlet(this.portletConfig);
            } else {
                logger.debug("The portlet container is designed to destroy the webapp context attributes prior to calling the portlet's destroy method.");
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    public void doFacesRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        if (this.initialized) {
            String nonFacesTargetPath = actionRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhaseActionImpl bridgePhase = new BridgePhaseActionImpl(actionRequest, actionResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(EventRequest eventRequest, EventResponse eventResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)eventRequest, (PortletResponse)eventResponse);
        if (this.initialized) {
            String nonFacesTargetPath = eventRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhaseEventImpl bridgePhase = new BridgePhaseEventImpl(eventRequest, eventResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(RenderRequest renderRequest, RenderResponse renderResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (this.initialized) {
            String nonFacesTargetPath = renderRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhaseRenderImpl bridgePhase = new BridgePhaseRenderImpl(renderRequest, renderResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhaseResourceImpl bridgePhase = new BridgePhaseResourceImpl(resourceRequest, resourceResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public String getTitle() {
        return BridgeImpl.class.getPackage().getImplementationTitle();
    }

    public String getVersion() {
        return BridgeImpl.class.getPackage().getImplementationVersion();
    }

    public void init(PortletConfig portletConfig) throws BridgeException {
        this.initialized = true;
        this.portletConfig = portletConfig;
        logger.info("Initializing {0} {1} for {2}:{3}", new Object[]{this.getTitle(), this.getVersion(), portletConfig.getPortletContext().getPortletContextName(), portletConfig.getPortletName()});
    }

    @Override
    protected void checkNull(PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletRequest == null) {
            throw new NullPointerException("portletRequest was null");
        }
        if (portletResponse == null) {
            throw new NullPointerException("portletResponse was null");
        }
    }

    @Override
    protected PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    @Override
    protected boolean isInitialized() {
        return this.initialized;
    }
}

