/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.component.inputfile.InputFile;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileDelegationResponseWriter;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileRendererCompat;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.event.FileUploadEvent;
import com.liferay.faces.bridge.model.UploadedFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.FacesRenderer;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.bridge.component.inputfile.InputFileRenderer")
public class InputFileRenderer
extends InputFileRendererCompat {
    static Map<String, List<UploadedFile>> getUploadedFileMap(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletContext portletContext = (PortletContext)externalContext.getContext();
        ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ContextMapFactory.class);
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        return contextMapFactory.getUploadedFileMap(portletRequest);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        InputFile inputFile = (InputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = InputFileRenderer.getUploadedFileMap(facesContext);
        if (!uploadedFileMap.isEmpty()) {
            String clientId = uiComponent.getClientId(facesContext);
            List<UploadedFile> uploadedFiles = uploadedFileMap.get(clientId);
            if (uploadedFiles != null && uploadedFiles.size() > 0) {
                ArrayList<UploadedFile> bridgeUploadedFiles = new ArrayList<UploadedFile>(uploadedFiles.size());
                for (UploadedFile uploadedFile : uploadedFiles) {
                    bridgeUploadedFiles.add(uploadedFile);
                }
                inputFile.setSubmittedValue(bridgeUploadedFiles);
                for (UploadedFile uploadedFile : uploadedFiles) {
                    FileUploadEvent fileUploadEvent = new FileUploadEvent(uiComponent, uploadedFile);
                    uiComponent.queueEvent((FacesEvent)fileUploadEvent);
                }
            } else {
                inputFile.setSubmittedValue(Collections.emptyList());
            }
        } else {
            inputFile.setSubmittedValue(Collections.emptyList());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputFileDelegationResponseWriter delegationResponseWriter = new InputFileDelegationResponseWriter(responseWriter);
        super.encodeEnd(facesContext, uiComponent, (ResponseWriter)delegationResponseWriter);
    }
}

