/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorWrapper;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceValidatorBridgeImpl
extends ResourceValidatorWrapper
implements Serializable {
    private static final long serialVersionUID = 5058022096981863159L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceValidatorBridgeImpl.class);
    private ResourceValidator wrappedResourceValidator;

    public ResourceValidatorBridgeImpl(ResourceValidator resourceValidator) {
        this.wrappedResourceValidator = resourceValidator;
    }

    public ResourceValidator getWrapped() {
        return this.wrappedResourceValidator;
    }

    public boolean isSelfReferencing(FacesContext facesContext, String resourceId) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Product PLUTO = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.PLUTO);
        boolean selfReferencing = super.isSelfReferencing(facesContext, resourceId);
        if (PLUTO.isDetected() && !selfReferencing && resourceId != null) {
            HashSet<String> invokerServletNames = new HashSet<String>();
            Map applicationMap = externalContext.getApplicationMap();
            ApplicationConfig applicationConfig = (ApplicationConfig)applicationMap.get(ApplicationConfig.class.getName());
            WebConfig webConfig = applicationConfig.getWebConfig();
            List configuredServlets = webConfig.getConfiguredServlets();
            for (ConfiguredServlet configuredServlet : configuredServlets) {
                String configuredServletClass = configuredServlet.getServletClass();
                if (!this.isInvokerServletClass(configuredServletClass)) continue;
                invokerServletNames.add(configuredServlet.getServletName());
            }
            List configuredServletMappings = webConfig.getConfiguredServletMappings();
            for (ConfiguredServletMapping configuredServletMapping : configuredServletMappings) {
                if (!invokerServletNames.contains(configuredServletMapping.getServletName()) || !configuredServletMapping.isMatch(resourceId)) continue;
                selfReferencing = true;
                break;
            }
        }
        return selfReferencing;
    }

    private boolean isInvokerServletClass(String servletClassFQCN) {
        boolean invokerServletClass = false;
        String invokerServletFQCN = "org.apache.pluto.container.driver.PortletServlet";
        if (invokerServletFQCN.equals(servletClassFQCN)) {
            invokerServletClass = true;
        } else {
            try {
                Class<?> invokerServletClazz = Class.forName(invokerServletFQCN);
                try {
                    Class<?> servletClazz = Class.forName(servletClassFQCN);
                    invokerServletClass = invokerServletClazz.isAssignableFrom(servletClazz);
                }
                catch (Throwable t) {
                    logger.error("Unable to load servletClassFQCN=[{0}] error=[{1}]", new Object[]{servletClassFQCN, t.getMessage()});
                }
            }
            catch (Throwable t) {
                logger.error("Unable to load invokerServletFQCN=[{0}] error=[{1}]", new Object[]{invokerServletFQCN, t.getMessage()});
            }
        }
        return invokerServletClass;
    }
}

