/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.component.inputfile.internal.HtmlInputFilePartImpl;
import com.liferay.faces.bridge.component.inputfile.internal.PartEmptyImpl;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import com.liferay.faces.util.render.DelegatingRendererBase;
import com.liferay.faces.util.render.RendererUtil;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

public class HtmlInputFileRenderer
extends DelegatingRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(HtmlInputFileRenderer.class);
    private Renderer delegateRenderer;

    public HtmlInputFileRenderer() {
        String delegateRendererFQCN = "com.sun.faces.renderkit.html_basic.FileRenderer";
        boolean MYFACES_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.MYFACES).isDetected();
        if (MYFACES_DETECTED) {
            delegateRendererFQCN = "org.apache.myfaces.renderkit.html.HtmlInputFileRenderer";
        }
        try {
            Class<?> delegateRendererClass = Class.forName(delegateRendererFQCN);
            this.delegateRenderer = (Renderer)delegateRendererClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientId;
        HtmlInputFile htmlInputFile = (HtmlInputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = this.getUploadedFileMap(facesContext);
        if (uploadedFileMap != null && uploadedFileMap.containsKey(clientId = uiComponent.getClientId(facesContext))) {
            List<UploadedFile> uploadedFiles = uploadedFileMap.get(clientId);
            if (uploadedFiles != null && uploadedFiles.size() > 0) {
                HtmlInputFilePartImpl part = new HtmlInputFilePartImpl(uploadedFiles.get(0), clientId);
                htmlInputFile.setTransient(true);
                htmlInputFile.setSubmittedValue((Object)part);
            } else {
                htmlInputFile.setSubmittedValue((Object)new PartEmptyImpl());
            }
        }
        RendererUtil.decodeClientBehaviors((FacesContext)facesContext, (UIComponent)uiComponent);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof PartEmptyImpl) {
            return null;
        }
        return submittedValue;
    }

    public String getDelegateComponentFamily() {
        return "javax.faces.Input";
    }

    public Renderer getDelegateRenderer(FacesContext facesContext) {
        return this.delegateRenderer;
    }

    public String getDelegateRendererType() {
        return "javax.faces.File";
    }

    protected Map<String, List<UploadedFile>> getUploadedFileMap(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletContext portletContext = (PortletContext)externalContext.getContext();
        ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ContextMapFactory.class);
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        return contextMapFactory.getUploadedFileMap(portletRequest);
    }
}

