/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.context.internal.ExternalContextImpl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeBaseImpl;
import com.liferay.faces.bridge.scope.internal.FacesContextAttribute;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;

public abstract class BridgeRequestScopeCompatImpl
extends BridgeRequestScopeBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeCompatImpl.class);
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES = "com.liferay.faces.bridge.facescontext.attributes";
    private Flash flash;

    protected void restoreFlashState(ExternalContext externalContext) {
        if (this.flash != null) {
            while (externalContext instanceof ExternalContextWrapper) {
                ExternalContextWrapper externalContextWrapper = (ExternalContextWrapper)externalContext;
                externalContext = externalContextWrapper.getWrapped();
            }
            if (externalContext instanceof ExternalContextImpl) {
                ExternalContextImpl externalContextImpl = (ExternalContextImpl)externalContext;
                externalContextImpl.setFlash(this.flash);
            } else {
                logger.error("Unable to get access to the bridge ExternalContextImpl");
            }
        }
    }

    protected void restoreJSF2FacesContextAttributes(FacesContext facesContext) {
        List savedFacesContextAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES);
        boolean restoredFacesContextAttibutes = false;
        if (savedFacesContextAttributes != null) {
            Map currentFacesContextAttributes = facesContext.getAttributes();
            for (FacesContextAttribute facesContextAttribute : savedFacesContextAttributes) {
                Object name = facesContextAttribute.getName();
                if (currentFacesContextAttributes.containsKey(name)) continue;
                Object value = facesContextAttribute.getValue();
                currentFacesContextAttributes.put(name, value);
                logger.trace("Restoring FacesContext attribute name=[{0}] value=[{1}]", new Object[]{name, value});
                restoredFacesContextAttibutes = true;
            }
        }
        if (restoredFacesContextAttibutes) {
            savedFacesContextAttributes.clear();
            logger.debug("Restored FacesContext attributes");
        } else {
            logger.debug("Did not restore any FacesContext attributes");
        }
    }

    protected void saveFlashState(ExternalContext externalContext) {
        this.flash = externalContext.getFlash();
    }

    protected void saveJSF2FacesContextAttributes(FacesContext facesContext) {
        Map currentFacesContextAttributes = facesContext.getAttributes();
        int mapSize = currentFacesContextAttributes.size();
        ArrayList<FacesContextAttribute> savedFacesContextAttributes = new ArrayList<FacesContextAttribute>(mapSize);
        for (Map.Entry mapEntry : currentFacesContextAttributes.entrySet()) {
            Object name = mapEntry.getKey();
            Object value = mapEntry.getValue();
            logger.trace("Saving FacesContext attribute name=[{0}] value=[{1}]", new Object[]{name, value});
            savedFacesContextAttributes.add(new FacesContextAttribute(name, value));
        }
        this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES, savedFacesContextAttributes);
    }
}

