/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.filter.BridgePortletRequestFactory;
import com.liferay.faces.bridge.filter.BridgePortletResponseFactory;
import com.liferay.faces.bridge.internal.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorFactory;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;

public class BridgePhaseResourceImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseResourceImpl.class);
    private static final boolean LIFERAY_PORTAL_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.LIFERAY_PORTAL).isDetected();
    private static final String[] URL_SEPARATOR_CHARS = new String[]{"?", "#", ";"};
    private ResourceRequest resourceRequest;
    private ResourceResponse resourceResponse;

    public BridgePhaseResourceImpl(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletConfig, bridgeConfig);
        this.resourceRequest = BridgePortletRequestFactory.getResourceRequestInstance((ResourceRequest)resourceRequest, (ResourceResponse)resourceResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
        this.resourceResponse = BridgePortletResponseFactory.getResourceResponseInstance((ResourceRequest)resourceRequest, (ResourceResponse)resourceResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(ResourceRequest, ResourceResponse) portletName=[{0}]", new Object[]{this.portletName});
        try {
            this.init((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse, Bridge.PortletPhase.RESOURCE_PHASE);
            if (this.isJSF2ResourceRequest(this.facesContext)) {
                logger.debug("Detected JSF2 resource request");
                this.handleJSF2ResourceRequest(this.facesContext);
            } else if (this.resourceRequest.getResourceID() != null && !this.resourceRequest.getResourceID().equals("wsrp")) {
                logger.debug("Detected non-Faces resource");
                String resourceId = this.resourceRequest.getResourceID();
                String autoResourceDispatch = this.portletConfig.getInitParameter("javax.portlet.automaticResourceDispatching");
                if (autoResourceDispatch != null && autoResourceDispatch.equalsIgnoreCase("true")) {
                    ExternalContext externalContext = this.facesContext.getExternalContext();
                    ResourceValidator resourceValidator = ResourceValidatorFactory.getResourceValidatorInstance((ExternalContext)externalContext);
                    if (resourceValidator.containsBannedPath(resourceId)) {
                        logger.warn("Invalid request for resource with banned path: resourceId=[{0}]", new Object[]{resourceId});
                        externalContext.setResponseStatus(200);
                    } else if (resourceValidator.isBannedSequence(resourceId)) {
                        logger.warn("Invalid request for resource with banned sequence: resourceId=[{0}]", new Object[]{resourceId});
                        externalContext.setResponseStatus(404);
                    } else if (resourceValidator.isFaceletDocument(this.facesContext, resourceId)) {
                        logger.warn("Invalid request for Facelet document: resourceId=[{0}]", new Object[]{resourceId});
                        externalContext.setResponseStatus(404);
                    } else {
                        String resourcePath = resourceId;
                        for (String urlSeparatorChar : URL_SEPARATOR_CHARS) {
                            int pos = resourcePath.indexOf(urlSeparatorChar);
                            if (pos <= 0) continue;
                            resourcePath = resourcePath.substring(0, pos);
                        }
                        if (resourcePath.trim().length() == 0) {
                            if (LIFERAY_PORTAL_DETECTED) {
                                logger.warn("Invalid request for resourceId=[] possibly due to Liferay Portal enforcing the portlet.resource.id.banned.paths.regexp property.");
                            } else {
                                logger.warn("Invalid request for resourceId=[].");
                                externalContext.setResponseStatus(404);
                            }
                        } else if (resourceValidator.isSelfReferencing(this.facesContext, resourcePath)) {
                            logger.warn("Invalid request for resource that is self-referencing: resourceId=[{0}]", new Object[]{resourceId});
                            externalContext.setResponseStatus(404);
                        } else {
                            boolean mappedToFacesServlet = false;
                            ConfiguredServletMapping explicitFacesServletExtensionMapping = this.getExplicitFacesServletExtensionMapping(resourcePath);
                            if (explicitFacesServletExtensionMapping != null) {
                                logger.warn("Invalid request for resource that is EXPLICITLY extension-mapped to the FacesServlet: resourceId=[{0}] resourcePath=[{1}] servlet-mapping extension=[{2}]", new Object[]{resourceId, resourcePath, explicitFacesServletExtensionMapping.getExtension()});
                                mappedToFacesServlet = true;
                                externalContext.setResponseStatus(404);
                            } else {
                                ConfiguredServletMapping facesServletPathMapping = this.getFacesServletPathMapping(resourceId);
                                if (facesServletPathMapping != null) {
                                    logger.warn("Invalid request for resource that is path-mapped to the FacesServlet: resourceId=[{0}] resourcePath=[{1}] servlet-mapping url-pattern=[{2}]", new Object[]{resourceId, resourcePath, facesServletPathMapping.getUrlPattern()});
                                    mappedToFacesServlet = true;
                                    externalContext.setResponseStatus(404);
                                }
                            }
                            if (!mappedToFacesServlet) {
                                PortletRequestDispatcher portletRequestDispatcher = this.portletContext.getRequestDispatcher(resourceId);
                                if (portletRequestDispatcher != null) {
                                    portletRequestDispatcher.forward((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse);
                                } else {
                                    logger.warn("Request for non-Faces resource=[{0}] but request dispatcher was null.", new Object[]{resourceId});
                                    externalContext.setResponseStatus(404);
                                }
                            }
                        }
                    }
                } else {
                    logger.warn("Request for non-Faces resource=[{0}] but automatic dispatching is disabled.", new Object[]{resourceId});
                }
            } else {
                ExternalContext externalContext = this.facesContext.getExternalContext();
                if (logger.isDebugEnabled()) {
                    String facesAjaxParameter = (String)externalContext.getRequestParameterMap().get("_jsfBridgeAjax");
                    if (BooleanHelper.isTrueToken((String)facesAjaxParameter)) {
                        logger.debug("Detected Ajax ResourceRequest");
                    } else {
                        logger.debug("Detected Non-Ajax ResourceRequest");
                    }
                }
                String viewId = this.getFacesViewId(externalContext);
                logger.debug("Running Faces lifecycle for viewId=[{0}]", new Object[]{viewId});
                this.attachClientWindowToLifecycle(this.facesContext, this.facesLifecycle);
                this.facesLifecycle.execute(this.facesContext);
                this.facesLifecycle.render(this.facesContext);
                if (this.bridgeRequestScope != null) {
                    this.bridgeRequestScope.setPortletMode(this.resourceRequest.getPortletMode());
                    this.bridgeRequestScope.saveState(this.facesContext);
                    this.maintainBridgeRequestScope((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse, BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE);
                }
                this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.resourceResponse);
            }
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            this.cleanup((PortletRequest)this.resourceRequest);
        }
        logger.debug("----------------------------------------------------------------------");
    }

    protected List<ConfiguredServletMapping> getConfiguredFacesServletMappings() {
        String appConfigAttrName = ApplicationConfig.class.getName();
        ExternalContext externalContext = this.facesContext.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        ApplicationConfig applicationConfig = (ApplicationConfig)applicationMap.get(appConfigAttrName);
        FacesConfig facesConfig = applicationConfig.getFacesConfig();
        return facesConfig.getConfiguredFacesServletMappings();
    }

    protected ConfiguredServletMapping getExplicitFacesServletExtensionMapping(String resourceId) {
        ConfiguredServletMapping explicitFacesServletExtensionMapping = null;
        List<ConfiguredServletMapping> facesServletMappings = this.getConfiguredFacesServletMappings();
        for (ConfiguredServletMapping facesServletMapping : facesServletMappings) {
            if (!facesServletMapping.isMatch(resourceId) || !facesServletMapping.isExtensionMapped() || facesServletMapping.isImplicit()) continue;
            explicitFacesServletExtensionMapping = facesServletMapping;
            break;
        }
        return explicitFacesServletExtensionMapping;
    }

    protected ConfiguredServletMapping getFacesServletPathMapping(String resourceId) {
        ConfiguredServletMapping facesServletPathMapping = null;
        List<ConfiguredServletMapping> facesServletMappings = this.getConfiguredFacesServletMappings();
        for (ConfiguredServletMapping facesServletMapping : facesServletMappings) {
            if (!facesServletMapping.isMatch(resourceId) || !facesServletMapping.isPathMapped()) continue;
            facesServletPathMapping = facesServletMapping;
            break;
        }
        return facesServletPathMapping;
    }
}

