/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.map.internal.AbstractMutablePropertyMap;
import com.liferay.faces.bridge.context.map.internal.RequestScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

public class RequestScopeMap
extends AbstractMutablePropertyMap<Object> {
    private BeanManager beanManager;
    private PortletRequest portletRequest;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;

    public RequestScopeMap(PortletContext portletContext, PortletRequest portletRequest, boolean preferPreDestroy) {
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        this.portletRequest = portletRequest;
        this.preferPreDestroy = preferPreDestroy;
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(portletContext);
    }

    public Object remove(Object key) {
        String keyAsString = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(keyAsString, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new RequestScopeMapEntry(this.portletRequest, name);
    }

    @Override
    protected Object getMutableProperty(String name) {
        return this.portletRequest.getAttribute(name);
    }

    @Override
    protected Enumeration<String> getMutablePropertyNames() {
        return this.portletRequest.getAttributeNames();
    }

    @Override
    protected void removeMutableProperty(String name) {
        this.portletRequest.removeAttribute(name);
    }

    @Override
    protected void setMutableProperty(String name, Object value) {
        this.portletRequest.setAttribute(name, value);
    }
}

