/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.CapturingWriter;
import com.liferay.faces.bridge.context.internal.WriterOperation;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CapturingWriterImpl
extends CapturingWriter {
    private List<WriterOperation> writerOperations = new ArrayList<WriterOperation>();

    @Override
    public void close() throws IOException {
        this.writerOperations.add(new CloseOperation());
    }

    @Override
    public void flush() throws IOException {
        this.writerOperations.add(new FlushOperation());
    }

    @Override
    public List<WriterOperation> getWriterOperations() {
        return this.writerOperations;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (cbuf != null) {
            this.writerOperations.add(new CbufWriteOperation(cbuf));
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.writerOperations.add(new IntWriteOperation(c));
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            this.writerOperations.add(new StrWriteOperation(str));
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            this.writerOperations.add(new CBufOffLenWriterOperation(cbuf, off, len));
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            this.writerOperations.add(new StrOffLenWriteOperation(str, off, len));
        }
    }

    private static class StrWriteOperation
    implements WriterOperation {
        private String str;

        public StrWriteOperation(String str) {
            this.str = str;
        }

        @Override
        public void invoke(Writer writer) throws IOException {
            writer.write(this.str);
        }
    }

    private static class StrOffLenWriteOperation
    implements WriterOperation {
        private String str;
        private int off;
        private int len;

        public StrOffLenWriteOperation(String str, int off, int len) {
            this.str = str;
            this.off = off;
            this.len = len;
        }

        @Override
        public void invoke(Writer writer) throws IOException {
            writer.write(this.str, this.off, this.len);
        }
    }

    private static class IntWriteOperation
    implements WriterOperation {
        private int c;

        public IntWriteOperation(int c) {
            this.c = c;
        }

        @Override
        public void invoke(Writer writer) throws IOException {
            writer.write(this.c);
        }
    }

    private static class FlushOperation
    implements WriterOperation {
        @Override
        public void invoke(Writer writer) throws IOException {
            writer.flush();
        }
    }

    private static class CloseOperation
    implements WriterOperation {
        @Override
        public void invoke(Writer writer) throws IOException {
            writer.close();
        }
    }

    private static class CbufWriteOperation
    implements WriterOperation {
        private char[] cbuf;

        public CbufWriteOperation(char[] cbuf) {
            this.cbuf = (char[])cbuf.clone();
        }

        @Override
        public void invoke(Writer writer) throws IOException {
            writer.write(this.cbuf);
        }
    }

    private static class CBufOffLenWriterOperation
    implements WriterOperation {
        private char[] cbuf;
        private int off;
        private int len;

        public CBufOffLenWriterOperation(char[] cbuf, int off, int len) {
            this.cbuf = (char[])cbuf.clone();
            this.off = off;
            this.len = len;
        }

        @Override
        public void invoke(Writer writer) throws IOException {
            writer.write(this.cbuf, this.off, this.len);
        }
    }
}

