/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class URLUtil {
    private static final Logger logger = LoggerFactory.getLogger(URLUtil.class);

    public static String escapeXML(String url) {
        char[] tokens = new char[]{'&', '<', '>', '\"', '\'', '\u00bb', '\u2013', '\u2014', '\u2028'};
        String[] replacements = new String[]{"&amp;", "&lt;", "&gt;", "&#034;", "&#039;", "&#187;", "&#x2013;", "&#x2014;", "&#x2028;"};
        for (int i = 0; i < tokens.length; ++i) {
            String token = Character.toString(tokens[i]);
            url = url.replace(token, replacements[i]);
        }
        return url;
    }

    public static Map<String, String[]> parseParameterMapValuesArray(String url) {
        int pos;
        LinkedHashMap<String, String[]> parameterMapValuesArray = new LinkedHashMap<String, String[]>();
        if (url != null && (pos = url.indexOf("?")) > 0) {
            String queryString = url.substring(pos + 1);
            if ((queryString = queryString.replaceAll("&amp;", "&")) != null && queryString.length() > 0) {
                String[] queryParameters;
                pos = queryString.indexOf("#");
                if (pos > 0) {
                    queryString = queryString.substring(0, pos);
                }
                for (String queryParameter : queryParameters = queryString.split("[&]")) {
                    String[] newValues;
                    String[] nameValueArray = queryParameter.split("[=]");
                    String name = nameValueArray[0].trim();
                    String[] existingValues = (String[])parameterMapValuesArray.get(name);
                    if (nameValueArray.length == 1) {
                        if (existingValues == null) {
                            newValues = new String[]{""};
                        } else {
                            newValues = Arrays.copyOf(existingValues, existingValues.length + 1);
                            newValues[existingValues.length] = "";
                        }
                        parameterMapValuesArray.put(name, newValues);
                        continue;
                    }
                    if (nameValueArray.length == 2) {
                        if (name.length() == 0) {
                            logger.error("Invalid name=value pair=[{0}] in URL=[{1}]: name cannot be empty", new Object[]{nameValueArray, url});
                            continue;
                        }
                        if (existingValues == null) {
                            newValues = new String[]{nameValueArray[1]};
                        } else {
                            newValues = Arrays.copyOf(existingValues, existingValues.length + 1);
                            newValues[existingValues.length] = nameValueArray[1];
                        }
                        parameterMapValuesArray.put(name, newValues);
                        continue;
                    }
                    logger.error("Invalid name=value pair=[{0}] in URL=[{1}]", new Object[]{nameValueArray, url});
                }
            }
        }
        return parameterMapValuesArray;
    }

    public static Map<String, List<String>> parseParameterMapValuesList(String url) {
        LinkedHashMap<String, List<String>> parameterMapValuesList = new LinkedHashMap<String, List<String>>();
        Map<String, String[]> parameterMapValuesArray = URLUtil.parseParameterMapValuesArray(url);
        Set<Map.Entry<String, String[]>> entrySet = parameterMapValuesArray.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entrySet) {
            String[] mapEntryValues = mapEntry.getValue();
            ArrayList<String> values = new ArrayList<String>(mapEntryValues.length);
            for (int i = 0; i < mapEntryValues.length; ++i) {
                values.add(mapEntryValues[i]);
            }
            parameterMapValuesList.put(mapEntry.getKey(), values);
        }
        return parameterMapValuesList;
    }
}

