/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.ResponseWriterResourceImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import javax.faces.render.RendererWrapper;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class ResourceRendererBridgeImpl
extends RendererWrapper
implements ComponentSystemEventListener,
StateHolder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRendererBridgeImpl.class);
    private boolean transientFlag;
    private Renderer wrappedRenderer;

    public ResourceRendererBridgeImpl() {
    }

    public ResourceRendererBridgeImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponentResource) throws IOException {
        boolean ajaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
        ResponseWriter responseWriter = null;
        if (ajaxRequest) {
            responseWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter((ResponseWriter)new ResponseWriterResourceImpl(facesContext, responseWriter));
        }
        super.encodeEnd(facesContext, uiComponentResource);
        if (ajaxRequest) {
            facesContext.setResponseWriter(responseWriter);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (this.wrappedRenderer instanceof ComponentSystemEventListener) {
            ComponentSystemEventListener wrappedListener = (ComponentSystemEventListener)this.wrappedRenderer;
            wrappedListener.processEvent(event);
        } else {
            logger.debug("Wrapped renderer=[{0}] does not implement ComponentSystemEventListener", new Object[]{this.wrappedRenderer});
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (this.wrappedRenderer == null) {
            try {
                String wrappedRendererClassName = (String)state;
                Class<?> wrappedRendererClass = Class.forName(wrappedRendererClassName);
                this.wrappedRenderer = (Renderer)wrappedRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        return this.wrappedRenderer.getClass().getName();
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }
}

