/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadManagedBean;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

final class RenderKitUtil {
    static final String HEAD_RESOURCES_TO_RENDER_IN_BODY = "headResourcesToRenderInBody";
    static final String SCRIPT_RENDERER_TYPE = "javax.faces.resource.Script";
    static final String STYLE_CLASS_PORTLET_BODY = "liferay-faces-bridge-body";
    static final String STYLESHEET_RENDERER_TYPE = "javax.faces.resource.Stylesheet";
    private static final boolean BOOTSFACES_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.BOOTSFACES).isDetected();

    private RenderKitUtil() {
        throw new AssertionError();
    }

    static Set<String> getHeadResourceIds(FacesContext facesContext) {
        HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
        Set<String> headResourceIds = headManagedBean == null ? new HashSet<String>() : headManagedBean.getHeadResourceIds();
        return headResourceIds;
    }

    static boolean isScriptResource(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String resourceLibrary = (String)componentResourceAttributes.get("library");
        return resourceName != null && resourceName.endsWith("js") || RenderKitUtil.isRichFacesReslibResource(resourceName, resourceLibrary) || RenderKitUtil.isBootsFacesNonJSFResource(resourceName, componentResourceAttributes, "js");
    }

    static boolean isStyleSheetResource(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        return resourceName != null && resourceName.endsWith("css") || RenderKitUtil.isBootsFacesNonJSFResource(resourceName, componentResourceAttributes, "css");
    }

    private static boolean isBootsFacesNonJSFResource(String resourceName, Map<String, Object> componentResourceAttributes, String resourceExtension) {
        String url;
        boolean bootsFacesResource = false;
        if (resourceName == null && BOOTSFACES_DETECTED && (url = (String)componentResourceAttributes.get("url")) != null) {
            int indexOfQuerySection = url.indexOf("?");
            if (indexOfQuerySection > -1) {
                url = url.substring(0, indexOfQuerySection);
            }
            bootsFacesResource = url.endsWith(resourceExtension);
        }
        return bootsFacesResource;
    }

    private static boolean isRichFacesReslibResource(String resourceName, String resourceLibrary) {
        return resourceName != null && resourceName.endsWith("reslib") && resourceLibrary != null && resourceLibrary.startsWith("org.richfaces");
    }
}

