/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.LongHelper;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class PortletConfigParamUtil {
    public static boolean getBooleanValue(PortletConfig portletConfig, String name, String alternateName, boolean defaultBooleanValue) {
        String configuredValue;
        String portletName;
        boolean booleanValue = defaultBooleanValue;
        if (name.startsWith("javax.portlet.faces.") && (portletName = portletConfig.getPortletName()) != null) {
            String namespacedContextAttributeName = "javax.portlet.faces." + portletName + "." + name.substring("javax.portlet.faces.".length());
            PortletContext portletContext = portletConfig.getPortletContext();
            Object namespacedContextAttributeValue = portletContext.getAttribute(namespacedContextAttributeName);
            if (namespacedContextAttributeValue != null) {
                booleanValue = namespacedContextAttributeValue instanceof Boolean ? (Boolean)namespacedContextAttributeValue : BooleanHelper.isTrueToken((String)namespacedContextAttributeValue.toString());
                return booleanValue;
            }
        }
        if ((configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName)) != null) {
            booleanValue = BooleanHelper.isTrueToken((String)configuredValue);
        }
        return booleanValue;
    }

    public static String getConfiguredValue(PortletConfig portletConfig, String name, String alternateName) {
        PortletContext portletContext = portletConfig.getPortletContext();
        String configuredValue = portletConfig.getInitParameter(name);
        if (configuredValue == null) {
            portletContext = portletConfig.getPortletContext();
            configuredValue = portletContext.getInitParameter(name);
        }
        if (configuredValue == null && alternateName != null && (configuredValue = portletConfig.getInitParameter(alternateName)) == null) {
            configuredValue = portletContext.getInitParameter(alternateName);
        }
        return configuredValue;
    }

    public static int getIntegerValue(PortletConfig portletConfig, String name, String alternateName, int defaultIntegerValue) {
        int integerValue = defaultIntegerValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                integerValue = IntegerHelper.toInteger((String)configuredValue);
            }
        } else {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                integerValue = IntegerHelper.toInteger((String)configuredValue);
            }
        }
        return integerValue;
    }

    public static long getLongValue(PortletConfig portletConfig, String name, String alternateName, long defaultLongValue) {
        long longValue = defaultLongValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                longValue = LongHelper.toLong((String)configuredValue);
            }
        } else {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                longValue = LongHelper.toLong((String)configuredValue);
            }
        }
        return longValue;
    }

    public static String getStringValue(PortletConfig portletConfig, String name, String alternateName, String defaultStringValue) {
        String stringValue = defaultStringValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                stringValue = configuredValue;
            }
        } else {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                stringValue = configuredValue;
            }
        }
        return stringValue;
    }

    public static boolean isSpecified(PortletConfig portletConfig, String name, String alternateName) {
        return PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName) != null;
    }
}

