/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.ExternalContextImpl;
import com.liferay.faces.bridge.context.internal.ExternalContextRichFacesImpl;
import com.liferay.faces.bridge.context.internal.ExternalContextRichFacesResourceImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class ExternalContextFactoryImpl
extends ExternalContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextFactoryImpl.class);
    private static final Product RICHFACES = ProductFactory.getProduct((Product.Name)Product.Name.RICHFACES);
    private static final boolean FACES_2638 = RICHFACES.isDetected() && RICHFACES.getMajorVersion() == 4 && RICHFACES.getMinorVersion() == 5 && RICHFACES.getPatchVersion() >= 16;
    private ExternalContextFactory wrappedFactory;

    public ExternalContextFactoryImpl(ExternalContextFactory externalContextFactory) {
        this.wrappedFactory = externalContextFactory;
    }

    public ExternalContext getExternalContext(Object context, Object request, Object response) throws FacesException {
        if (context instanceof PortletContext) {
            PortletContext portletContext = (PortletContext)context;
            PortletRequest portletRequest = (PortletRequest)request;
            PortletResponse portletResponse = (PortletResponse)response;
            ExternalContextImpl externalContext = new ExternalContextImpl(portletContext, portletRequest, portletResponse);
            String resourceName = portletRequest.getParameter("javax.faces.resource");
            if ("org.richfaces.resource.MediaOutputResource".equals(resourceName)) {
                return new ExternalContextRichFacesResourceImpl(externalContext);
            }
            if (FACES_2638) {
                return new ExternalContextRichFacesImpl(portletContext, portletRequest, portletResponse);
            }
            return externalContext;
        }
        logger.debug("Received a non-portlet request; delegating to wrapped ExternalContextFactory");
        return this.wrappedFactory.getExternalContext(context, request, response);
    }

    public ExternalContextFactory getWrapped() {
        return this.wrappedFactory;
    }
}

