/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class BridgeSessionListener
implements HttpSessionListener,
ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(BridgeSessionListener.class);
    private static final String MOJARRA_ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private static final String MOJARRA_PACKAGE_PREFIX = "com.sun.faces";
    private static final String MOJARRA_VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private boolean firstInstance;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (servletContext.getAttribute(BridgeSessionListener.class.getName()) == null) {
            logger.info("Context initialized for contextPath=[{0}]", new Object[]{servletContext.getContextPath()});
            servletContext.setAttribute(BridgeSessionListener.class.getName(), (Object)Boolean.TRUE);
            this.firstInstance = true;
        } else {
            logger.debug("Preventing multiple instantiation for contextPath=[{0}]", new Object[]{servletContext.getContextPath()});
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.firstInstance) {
            ServletContext servletContext;
            Product mojarra = ProductFactory.getProduct((Product.Name)Product.Name.MOJARRA);
            boolean mojarraAbleToCleanup = true;
            if (mojarra.isDetected() && mojarra.getMajorVersion() == 2 && mojarra.getMinorVersion() == 1 && mojarra.getPatchVersion() < 18) {
                mojarraAbleToCleanup = false;
                boolean logWarning = true;
                Product iceFaces = ProductFactory.getProduct((Product.Name)Product.Name.ICEFACES);
                if (iceFaces.isDetected() && (iceFaces.getMajorVersion() == 2 || iceFaces.getMajorVersion() == 3 && iceFaces.getMinorVersion() <= 2)) {
                    logWarning = false;
                }
                if (logWarning) {
                    logger.warn("Unable to cleanup ViewScoped managed-beans upon session expiration. Please upgrade to Mojarra 2.1.18 or newer. For more info, see: http://issues.liferay.com/browse/FACES-1470");
                }
            }
            BeanManagerFactory beanManagerFactory = null;
            BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory = null;
            try {
                beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
                bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeManagerFactory.class);
            }
            catch (Exception e) {
                HttpSession httpSession;
                String contextPath = "unknown";
                if (httpSessionEvent != null && (httpSession = httpSessionEvent.getSession()) != null && (servletContext = httpSession.getServletContext()) != null) {
                    contextPath = servletContext.getContextPath();
                }
                logger.error("Unable to discover factories for contextPath=[{0}] possibly because the portlet never received a RenderRequest", new Object[]{contextPath});
            }
            if (beanManagerFactory != null && bridgeRequestScopeManagerFactory != null) {
                HttpSession httpSession = httpSessionEvent.getSession();
                BridgeRequestScopeManager bridgeRequestScopeManager = bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                bridgeRequestScopeManager.removeBridgeRequestScopesBySession(httpSession);
                String appConfigAttrName = ApplicationConfig.class.getName();
                servletContext = httpSession.getServletContext();
                ApplicationConfig applicationConfig = (ApplicationConfig)servletContext.getAttribute(appConfigAttrName);
                BeanManager beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
                try {
                    Enumeration attributeNames = httpSession.getAttributeNames();
                    while (attributeNames.hasMoreElements()) {
                        HttpSessionListener viewScopeManager;
                        int pos;
                        String attributeName = (String)attributeNames.nextElement();
                        if (attributeName == null || !attributeName.startsWith("javax.portlet.p.") || (pos = attributeName.indexOf("?")) <= 0) continue;
                        Object attributeValue = httpSession.getAttribute(attributeName);
                        httpSession.removeAttribute(attributeName);
                        if (attributeValue == null) continue;
                        if (beanManager.isManagedBean(attributeName, attributeValue)) {
                            PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory(PreDestroyInvokerFactory.class);
                            PreDestroyInvoker preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(servletContext);
                            preDestroyInvoker.invokeAnnotatedMethods(attributeValue, true);
                            continue;
                        }
                        String attributeValueClassName = attributeValue.getClass().getName();
                        if (!attributeName.contains(MOJARRA_ACTIVE_VIEW_MAPS) && !attributeValueClassName.contains(MOJARRA_PACKAGE_PREFIX)) continue;
                        String nonPrefixedName = attributeName.substring(pos + 1);
                        logger.debug("Renaming Mojarra session attributeName=[{0}] -> [{1}]", new Object[]{attributeName, nonPrefixedName});
                        httpSession.setAttribute(nonPrefixedName, attributeValue);
                        if (!MOJARRA_ACTIVE_VIEW_MAPS.equals(nonPrefixedName) || !mojarraAbleToCleanup || (viewScopeManager = (HttpSessionListener)servletContext.getAttribute(MOJARRA_VIEW_SCOPE_MANAGER)) == null) continue;
                        try {
                            logger.debug("Asking Mojarra ViewScopeManager to cleanup @ViewScoped managed-beans");
                            viewScopeManager.sessionDestroyed(httpSessionEvent);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                catch (IllegalStateException e) {
                    logger.warn("Server does not permit cleanup of Mojarra managed-beans during session expiration");
                }
            }
        }
    }
}

