/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.RequestAttributeInspector;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;

public class RequestAttributeInspectorImpl
implements RequestAttributeInspector,
Serializable {
    private static final long serialVersionUID = 1876589389345663517L;
    private static final Logger logger = LoggerFactory.getLogger(RequestAttributeInspectorImpl.class);
    private static final String EXCLUDED_NAMESPACE_JAVAX_FACES = "javax.faces";
    private static final String EXCLUDED_NAMESPACE_JAVAX_PORTLET = "javax.portlet";
    private static final String EXCLUDED_NAMESPACE_JAVAX_PORTLET_FACES = "javax.portlet.faces";
    private static final String EXCLUCED_NAMESPACE_JAVAX_SERVLET = "javax.servlet";
    private static final String EXCLUCED_NAMESPACE_JAVAX_SERVLET_INCLUDE = "javax.servlet.include";
    private List<String> excludedAttributeNames = new ArrayList<String>();
    private Set<String> preExistingAttributeNames;

    public RequestAttributeInspectorImpl(PortletRequest portletRequest, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        PortletContext portletContext = portletConfig.getPortletContext();
        String portletName = portletConfig.getPortletName();
        List portletContextExcludedAttributeNames = (List)portletContext.getAttribute("javax.portlet.faces." + portletName + "." + "excludedRequestAttributes");
        Set facesConfigExcludedAttributeNames = bridgeConfig.getExcludedRequestAttributes();
        if (facesConfigExcludedAttributeNames != null) {
            this.excludedAttributeNames.addAll(facesConfigExcludedAttributeNames);
        }
        if (portletContextExcludedAttributeNames != null) {
            this.excludedAttributeNames.addAll(portletContextExcludedAttributeNames);
        }
        this.preExistingAttributeNames = this.getPreExistingRequestAttributeNames(portletRequest);
    }

    public boolean containsExcludedNamespace(String name) {
        return this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_FACES) || this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_PORTLET) || this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_PORTLET_FACES) || this.isNamespaceMatch(name, EXCLUCED_NAMESPACE_JAVAX_SERVLET) || this.isNamespaceMatch(name, EXCLUCED_NAMESPACE_JAVAX_SERVLET_INCLUDE);
    }

    public boolean isExcludedByAnnotation(String name, Object value) {
        boolean excluded = false;
        if (value != null && value.getClass().getAnnotation(ExcludeFromManagedRequestScope.class) != null) {
            excluded = true;
        }
        return excluded;
    }

    public boolean isExcludedByConfig(String name, Object value) {
        boolean excluded = false;
        if (this.excludedAttributeNames != null) {
            for (String excludedAttribute : this.excludedAttributeNames) {
                if (name.equals(excludedAttribute)) {
                    excluded = true;
                    break;
                }
                if (!excludedAttribute.endsWith("*")) continue;
                String wildcardNamespace = excludedAttribute;
                int dotPos = wildcardNamespace.lastIndexOf(".");
                if (dotPos > 0) {
                    wildcardNamespace = wildcardNamespace.substring(0, dotPos);
                }
                if (!this.isNamespaceMatch(name, wildcardNamespace)) continue;
                excluded = true;
                break;
            }
        }
        return excluded;
    }

    public boolean isExcludedByPreExisting(String name, Object value) {
        return this.preExistingAttributeNames.contains(name);
    }

    public boolean isExcludedByType(String name, Object value) {
        return value != null && (value instanceof ExternalContext || value instanceof FacesContext || value instanceof HttpSession || value instanceof PortalContext || value instanceof PortletConfig || value instanceof PortletContext || value instanceof PortletPreferences || value instanceof PortletRequest || value instanceof PortletResponse || value instanceof PortletSession || value instanceof ServletConfig || value instanceof ServletContext || value instanceof ServletRequest || value instanceof ServletResponse);
    }

    protected Set<String> getPreExistingRequestAttributeNames(PortletRequest portletRequest) {
        HashSet<String> attributeNames = null;
        Enumeration requestAttributeNames = portletRequest.getAttributeNames();
        if (requestAttributeNames != null) {
            attributeNames = new HashSet<String>();
            while (requestAttributeNames.hasMoreElements()) {
                String attributeName = (String)requestAttributeNames.nextElement();
                attributeNames.add(attributeName);
                logger.trace("Saving name of pre-existing request attribute [{0}]", new Object[]{attributeName});
            }
        }
        return attributeNames;
    }

    protected boolean isNamespaceMatch(String attributeName, String namespace) {
        boolean match = false;
        String attributeNamespace = attributeName;
        int dotPos = attributeNamespace.lastIndexOf(".");
        if (dotPos > 0) {
            attributeNamespace = attributeNamespace.substring(0, dotPos);
        }
        if (namespace.equals(attributeNamespace)) {
            match = true;
        }
        return match;
    }
}

