/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeCache;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeCacheFactory;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class BridgeRequestScopeManagerImpl
implements BridgeRequestScopeManager {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeManagerImpl.class);

    @Override
    public void removeBridgeRequestScopesByPortlet(PortletConfig portletConfig) {
        String portletNameToRemove = portletConfig.getPortletName();
        PortletContext portletContext = portletConfig.getPortletContext();
        BridgeRequestScopeCache bridgeRequestScopeCache = BridgeRequestScopeCacheFactory.getBridgeRequestScopeCacheInstance(portletContext);
        Set mapEntries = bridgeRequestScopeCache.entrySet();
        if (mapEntries != null) {
            ArrayList keysToRemove = new ArrayList();
            for (Map.Entry mapEntry : mapEntries) {
                BridgeRequestScope bridgeRequestScope = (BridgeRequestScope)mapEntry.getValue();
                String bridgeRequestScopeId = bridgeRequestScope.getId();
                String portletName = bridgeRequestScopeId.split("[:][:][:]")[0];
                if (!portletNameToRemove.equals(portletName)) continue;
                keysToRemove.add(mapEntry.getKey());
            }
            for (String key : keysToRemove) {
                bridgeRequestScopeCache.remove(key);
            }
        }
    }

    @Override
    public void removeBridgeRequestScopesBySession(HttpSession httpSession) {
        String httpSessionId = httpSession.getId();
        ServletContext servletContext = httpSession.getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attributeValue = servletContext.getAttribute(attributeName);
                if (attributeValue == null || !(attributeValue instanceof Map)) continue;
                Map map = (Map)attributeValue;
                Set entrySet = null;
                try {
                    entrySet = map.entrySet();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (entrySet == null) continue;
                ArrayList keysToRemove = new ArrayList();
                Iterator i$ = entrySet.iterator();
                while (i$.hasNext()) {
                    BridgeRequestScope bridgeRequestScope;
                    String bridgeRequestScopeSessionId;
                    Map.Entry mapEntryAsObject;
                    Map.Entry mapEntry = mapEntryAsObject = i$.next();
                    Object key = mapEntry.getKey();
                    Object value = mapEntry.getValue();
                    if (value == null || !(value instanceof BridgeRequestScope) || !httpSessionId.equals(bridgeRequestScopeSessionId = (bridgeRequestScope = (BridgeRequestScope)value).getId().split("[:][:][:]")[1])) continue;
                    keysToRemove.add(key);
                }
                for (Map.Entry bridgeRequestScopeId : keysToRemove) {
                    Object bridgeRequestScope = map.remove(bridgeRequestScopeId);
                    logger.debug("Removed bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}] from cache due to session timeout", new Object[]{bridgeRequestScopeId, bridgeRequestScope});
                }
            }
        }
    }
}

