/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.RequestAttributeInspector;
import com.liferay.faces.bridge.RequestAttributeInspectorFactory;
import com.liferay.faces.bridge.context.internal.IncongruityContext;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.internal.IncongruityAttribute;
import com.liferay.faces.bridge.scope.internal.RequestAttribute;
import com.liferay.faces.bridge.util.internal.FacesMessageWrapper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class BridgeRequestScopeImpl
extends BridgeRequestScopeCompat_2_2_Impl
implements Serializable {
    private static final long serialVersionUID = 7113251688518329851L;
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeImpl.class);
    private static final String BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS = "com.liferay.faces.bridge.actionParams";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES = "com.liferay.faces.bridge.faces.messages";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT = "com.liferay.faces.bridge.faces.view.root";
    private static final String BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES = "com.liferay.faces.bridge.incongruitycontext.attributes";
    private static final String BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES = "com.liferay.faces.bridge.faces.request.attributes";
    protected static final String BRIDGE_REQ_SCOPE_NON_EXCLUDED_ATTR_NAMES = "com.liferay.faces.bridge.nonExcludedAttributeNames";
    private static final String JAVAX_FACES_ENCODED_URL_PARAM = "javax.faces.encodedURL";
    private Bridge.PortletPhase beganInPhase;
    private long dateCreated;
    private boolean facesLifecycleExecuted;
    private String idPrefix;
    private String idSuffix;
    private boolean navigationOccurred;
    private PortletMode portletMode;
    private boolean portletModeChanged;
    private boolean preserveActionParams;
    private boolean redirect;
    private Set<String> removedAttributeNames;
    private RequestAttributeInspector requestAttributeInspector;

    public BridgeRequestScopeImpl(PortletRequest portletRequest, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        GregorianCalendar calendar = new GregorianCalendar();
        this.dateCreated = calendar.getTimeInMillis();
        String portletName = portletConfig.getPortletName();
        PortletSession portletSession = portletRequest.getPortletSession();
        String sessionId = portletSession.getId();
        this.idPrefix = portletName + ":::" + sessionId + ":::";
        this.idSuffix = Long.toString(this.dateCreated);
        this.portletMode = PortletMode.VIEW;
        this.beganInPhase = (Bridge.PortletPhase)portletRequest.getAttribute("javax.portlet.faces.phase");
        this.preserveActionParams = PortletConfigParam.PreserveActionParams.getBooleanValue(portletConfig);
        this.removedAttributeNames = new HashSet<String>();
        this.requestAttributeInspector = RequestAttributeInspectorFactory.getRequestAttributeInspectorInstance((PortletRequest)portletRequest, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
    }

    @Override
    public Bridge.PortletPhase getBeganInPhase() {
        return this.beganInPhase;
    }

    @Override
    public long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public String getId() {
        return this.idPrefix + this.idSuffix;
    }

    @Override
    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    @Override
    public Map<String, String> getPreservedActionParameterMap() {
        return (Map)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS);
    }

    @Override
    public String getPreservedViewStateParam() {
        return (String)this.getAttribute("javax.faces.ViewState");
    }

    @Override
    public Set<String> getRemovedAttributeNames() {
        return this.removedAttributeNames;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isFacesLifecycleExecuted() {
        return this.facesLifecycleExecuted;
    }

    @Override
    public boolean isNavigationOccurred() {
        return this.navigationOccurred;
    }

    @Override
    public boolean isPortletModeChanged() {
        return this.portletModeChanged;
    }

    @Override
    public boolean isRedirectOccurred() {
        return this.redirect;
    }

    @Override
    public void release(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        String postRedirectGetSupport = portalContext.getProperty("com.liferay.faces.bridge.post.redirect.get.support");
        if (postRedirectGetSupport == null) {
            HashSet<String> attributeNamesToRemove = new HashSet<String>();
            Enumeration attributeNames = portletRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                Object attributeValue;
                String attributeName = (String)attributeNames.nextElement();
                if (this.requestAttributeInspector.isExcludedByPreExisting(attributeName, attributeValue = portletRequest.getAttribute(attributeName))) continue;
                attributeNamesToRemove.add(attributeName);
            }
            for (String attributeName : attributeNamesToRemove) {
                portletRequest.removeAttribute(attributeName);
                logger.debug("Removed request attribute name=[{0}] since it did not exist before the FacesContext was acquired.", new Object[]{attributeName});
            }
        }
    }

    @Override
    public void removeExcludedAttributes(RenderRequest renderRequest) {
        List nonExcludedAttributeNames;
        if ((this.isRedirectOccurred() || this.isPortletModeChanged()) && (nonExcludedAttributeNames = (List)this.getAttribute(BRIDGE_REQ_SCOPE_NON_EXCLUDED_ATTR_NAMES)) != null) {
            for (String attributeName : nonExcludedAttributeNames) {
                renderRequest.removeAttribute(attributeName);
                this.removedAttributeNames.add(attributeName);
                if (!logger.isTraceEnabled()) continue;
                if (this.isRedirectOccurred()) {
                    logger.trace("Due to redirect, removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{attributeName});
                    continue;
                }
                logger.trace("Due to PortletMode change, removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{attributeName});
            }
        }
        Enumeration attributeNames = renderRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeValue;
            String attributeName = (String)attributeNames.nextElement();
            if (this.requestAttributeInspector.isExcludedByPreExisting(attributeName, attributeValue = renderRequest.getAttribute(attributeName))) {
                if (this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue)) {
                    renderRequest.removeAttribute(attributeName);
                    logger.debug("Removed request attribute name=[{0}] since it was specified for removal.", new Object[]{attributeName});
                    continue;
                }
                logger.debug("Kept request attribute name=[{0}] since it existed prior to the FacesContext being created.", new Object[]{attributeName});
                continue;
            }
            if (!this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue) && !this.requestAttributeInspector.isExcludedByAnnotation(attributeName, attributeValue) && !this.requestAttributeInspector.isExcludedByType(attributeName, attributeValue) && !this.requestAttributeInspector.containsExcludedNamespace(attributeName)) continue;
            renderRequest.removeAttribute(attributeName);
            logger.debug("Removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{attributeName});
        }
    }

    @Override
    public void restoreState(FacesContext facesContext) {
        List savedIncongruityAttributes;
        Object value;
        ExternalContext externalContext;
        PortletRequest portletRequest;
        logger.debug("restoreState(facesContext)");
        boolean restoreNonExcludedRequestAttributes = this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE;
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE && !this.portletMode.equals((Object)(portletRequest = (PortletRequest)(externalContext = facesContext.getExternalContext()).getRequest()).getPortletMode())) {
            this.setPortletModeChanged(true);
            restoreNonExcludedRequestAttributes = false;
        }
        if (this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            UIViewRoot uiViewRoot = (UIViewRoot)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT);
            if (uiViewRoot != null) {
                facesContext.setViewRoot(uiViewRoot);
                logger.debug("Restored viewId=[{0}] uiViewRoot=[{1}]", new Object[]{uiViewRoot.getViewId(), uiViewRoot});
            } else {
                logger.debug("Did not restore uiViewRoot");
            }
            List facesMessages = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES);
            boolean restoredFacesMessages = false;
            if (facesMessages != null) {
                for (FacesMessageWrapper facesMessageWrapper : facesMessages) {
                    String clientId = facesMessageWrapper.getClientId();
                    FacesMessage facesMessage = facesMessageWrapper.getFacesMessage();
                    facesContext.addMessage(clientId, facesMessage);
                    logger.trace("Restored facesMessage=[{0}]", new Object[]{facesMessage.getSummary()});
                    restoredFacesMessages = true;
                }
            }
            if (restoredFacesMessages) {
                logger.debug("Restored facesMessages");
            } else {
                logger.debug("Did not restore any facesMessages");
            }
            this.restoreJSF2FacesContextAttributes(facesContext);
        }
        if (restoreNonExcludedRequestAttributes) {
            List savedRequestAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES);
            boolean restoredNonExcludedRequestAttributes = false;
            if (savedRequestAttributes != null) {
                ExternalContext externalContext2 = facesContext.getExternalContext();
                Map currentRequestAttributes = externalContext2.getRequestMap();
                if (!this.isRedirectOccurred()) {
                    for (RequestAttribute requestAttribute : savedRequestAttributes) {
                        String name = (String)requestAttribute.getName();
                        value = requestAttribute.getValue();
                        logger.trace("Restoring non-excluded request attribute name=[{0}] value=[{1}]", new Object[]{name, value});
                        currentRequestAttributes.put(name, value);
                        restoredNonExcludedRequestAttributes = true;
                    }
                }
            }
            if (restoredNonExcludedRequestAttributes) {
                logger.debug("Restored non-excluded request attributes");
            } else {
                logger.debug("Did not restore any non-excluded request attributes");
            }
        }
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE) {
            externalContext = facesContext.getExternalContext();
            this.restoreFlashState(externalContext);
            this.restoreClientWindow(facesContext.getExternalContext());
        }
        if ((this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE) && portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE && (savedIncongruityAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES)) != null) {
            ExternalContext externalContext3 = facesContext.getExternalContext();
            IncongruityContext incongruityContext = (IncongruityContext)((Object)externalContext3.getRequestMap().get(IncongruityContext.class.getName()));
            Map<String, Object> incongruityContextAttributes = incongruityContext.getAttributes();
            for (IncongruityAttribute incongruityAttribute : savedIncongruityAttributes) {
                String key = (String)incongruityAttribute.getName();
                value = incongruityAttribute.getValue();
                incongruityContextAttributes.put(key, value);
            }
        }
    }

    @Override
    public void saveState(FacesContext facesContext) {
        Bridge.PortletPhase portletRequestPhase;
        logger.debug("saveState(facesContext)");
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletResponse portletResponse = (PortletResponse)facesContext.getExternalContext().getResponse();
        if (this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            String viewState;
            this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT, facesContext.getViewRoot());
            if (!this.isPortletModeChanged() && portletResponse instanceof ActionResponse && (viewState = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState")) != null) {
                this.setAttribute("javax.faces.ViewState", viewState);
            }
            if (this.preserveActionParams) {
                HashMap actionRequestParameterMap = new HashMap(externalContext.getRequestParameterMap());
                actionRequestParameterMap.remove("javax.faces.ViewState");
                actionRequestParameterMap.remove(JAVAX_FACES_ENCODED_URL_PARAM);
                this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS, actionRequestParameterMap);
            }
            ArrayList<FacesMessageWrapper> facesMessageWrappers = new ArrayList<FacesMessageWrapper>();
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator facesMessages = facesContext.getMessages(clientId);
                while (facesMessages.hasNext()) {
                    FacesMessage facesMessage = (FacesMessage)facesMessages.next();
                    FacesMessageWrapper facesMessageWrapper = new FacesMessageWrapper(clientId, facesMessage);
                    facesMessageWrappers.add(facesMessageWrapper);
                }
            }
            if (facesMessageWrappers.size() > 0) {
                this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES, facesMessageWrappers);
            } else {
                logger.trace("Not saving any faces messages");
            }
            this.saveJSF2FacesContextAttributes(facesContext);
            boolean saveNonExcludedAttributes = true;
            if (this.isRedirectOccurred()) {
                logger.trace("Due to redirect, not saving any non-excluded request attributes");
                saveNonExcludedAttributes = false;
            } else if (this.isPortletModeChanged()) {
                logger.trace("Due to PortletMode change, not saving any non-excluded request attributes");
                saveNonExcludedAttributes = false;
            }
            Map currentRequestAttributes = externalContext.getRequestMap();
            if (currentRequestAttributes != null) {
                ArrayList<RequestAttribute> savedRequestAttributes = new ArrayList<RequestAttribute>();
                ArrayList<String> nonExcludedAttributeNames = new ArrayList<String>();
                for (Map.Entry mapEntry : currentRequestAttributes.entrySet()) {
                    Object attributeValue;
                    String attributeName = (String)mapEntry.getKey();
                    if (this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue = mapEntry.getValue()) || this.requestAttributeInspector.isExcludedByAnnotation(attributeName, attributeValue) || this.requestAttributeInspector.containsExcludedNamespace(attributeName) || this.requestAttributeInspector.isExcludedByType(attributeName, attributeValue) || this.requestAttributeInspector.isExcludedByPreExisting(attributeName, attributeValue)) {
                        logger.trace("NOT saving EXCLUDED attribute name=[{0}]", new Object[]{attributeName});
                        continue;
                    }
                    if (saveNonExcludedAttributes) {
                        logger.trace("SAVING non-excluded request attribute name=[{0}] value=[{1}]", new Object[]{attributeName, attributeValue});
                        savedRequestAttributes.add(new RequestAttribute(attributeName, attributeValue));
                    }
                    nonExcludedAttributeNames.add(attributeName);
                }
                if (savedRequestAttributes.size() > 0) {
                    this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES, savedRequestAttributes);
                } else {
                    logger.trace("Not saving any non-excluded request attributes");
                }
                this.setAttribute(BRIDGE_REQ_SCOPE_NON_EXCLUDED_ATTR_NAMES, nonExcludedAttributeNames);
            } else {
                logger.trace("Not saving any non-excluded request attributes because there are no request attributes!");
            }
        }
        if ((portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext)) == Bridge.PortletPhase.ACTION_PHASE || portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE) {
            this.saveFlashState(externalContext);
            this.saveClientWindow(externalContext);
        }
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE || portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE) {
            IncongruityContext incongruityContext = (IncongruityContext)((Object)externalContext.getRequestMap().get(IncongruityContext.class.getName()));
            Map<String, Object> incongruityAttributeMap = incongruityContext.getAttributes();
            int mapSize = incongruityAttributeMap.size();
            ArrayList<IncongruityAttribute> savedIncongruityAttributes = new ArrayList<IncongruityAttribute>(mapSize);
            for (Map.Entry<String, Object> mapEntry : incongruityAttributeMap.entrySet()) {
                String name = mapEntry.getKey();
                Object value = mapEntry.getValue();
                logger.trace("Saving IncongruityContext attribute name=[{0}] value=[{1}]", new Object[]{name, value});
                savedIncongruityAttributes.add(new IncongruityAttribute(name, value));
            }
            this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES, savedIncongruityAttributes);
        }
    }

    @Override
    public void setFacesLifecycleExecuted(boolean facesLifecycleExecuted) {
        this.facesLifecycleExecuted = facesLifecycleExecuted;
    }

    @Override
    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    @Override
    public void setNavigationOccurred(boolean navigationOccurred) {
        this.navigationOccurred = navigationOccurred;
    }

    @Override
    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    @Override
    public void setPortletModeChanged(boolean portletModeChanged) {
        this.portletModeChanged = portletModeChanged;
    }

    @Override
    public void setRedirectOccurred(boolean redirect) {
        this.redirect = redirect;
    }

    public String toString() {
        return this.getClass().getName().concat("@").concat(Integer.toHexString(this.hashCode()));
    }
}

