/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.bridge.internal.ResponseWriterBridgeImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.BodyRendererBridgeImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadRendererBridgeImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.ResourceRendererBridgeImpl;
import com.liferay.faces.bridge.renderkit.icefaces.internal.HeadRendererICEfacesImpl;
import com.liferay.faces.bridge.renderkit.primefaces.internal.FileUploadRendererPrimeFacesImpl;
import com.liferay.faces.bridge.renderkit.primefaces.internal.FormRendererPrimeFacesImpl;
import com.liferay.faces.bridge.renderkit.primefaces.internal.HeadRendererPrimeFacesImpl;
import com.liferay.faces.bridge.renderkit.richfaces.internal.FileUploadRendererRichFacesImpl;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.Writer;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;

public class RenderKitBridgeImpl
extends RenderKitWrapper {
    static final String SCRIPT_RENDERER_TYPE = "javax.faces.resource.Script";
    static final String STYLESHEET_RENDERER_TYPE = "javax.faces.resource.Stylesheet";
    private static final boolean ICEFACES_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.ICEFACES).isDetected();
    private static final String JAVAX_FACES_BODY = "javax.faces.Body";
    private static final String JAVAX_FACES_FORM = "javax.faces.Form";
    private static final String JAVAX_FACES_HEAD = "javax.faces.Head";
    private static final Product PRIMEFACES = ProductFactory.getProduct((Product.Name)Product.Name.PRIMEFACES);
    private static final boolean PRIMEFACES_DETECTED = PRIMEFACES.isDetected();
    private static final String PRIMEFACES_FAMILY = "org.primefaces.component";
    private static final String RICHFACES_FILE_UPLOAD_FAMILY = "org.richfaces.FileUpload";
    private static final String RICHFACES_FILE_UPLOAD_RENDERER_TYPE = "org.richfaces.FileUploadRenderer";
    private RenderKit wrappedRenderKit;

    public RenderKitBridgeImpl(RenderKit wrappedRenderKit) {
        this.wrappedRenderKit = wrappedRenderKit;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        ResponseWriter wrappedResponseWriter = this.wrappedRenderKit.createResponseWriter(writer, contentTypeList, characterEncoding);
        return new ResponseWriterBridgeImpl(wrappedResponseWriter);
    }

    public Renderer getRenderer(String family, String rendererType) {
        Object renderer = super.getRenderer(family, rendererType);
        if ("javax.faces.Output".equals(family)) {
            if (JAVAX_FACES_HEAD.equals(rendererType)) {
                renderer = ICEFACES_DETECTED ? new HeadRendererICEfacesImpl() : (PRIMEFACES_DETECTED ? new HeadRendererPrimeFacesImpl() : new HeadRendererBridgeImpl());
            } else if (JAVAX_FACES_BODY.equals(rendererType)) {
                renderer = new BodyRendererBridgeImpl((Renderer)renderer);
            } else if (SCRIPT_RENDERER_TYPE.equals(rendererType) || STYLESHEET_RENDERER_TYPE.equals(rendererType)) {
                renderer = new ResourceRendererBridgeImpl((Renderer)renderer);
            }
        } else if (JAVAX_FACES_FORM.equals(family) && JAVAX_FACES_FORM.equals(rendererType) && PRIMEFACES_DETECTED) {
            renderer = new FormRendererPrimeFacesImpl(PRIMEFACES.getMajorVersion(), PRIMEFACES.getMinorVersion(), (Renderer)renderer);
        } else if (PRIMEFACES_FAMILY.equals(family) && "org.primefaces.component.FileUploadRenderer".equals(rendererType)) {
            renderer = new FileUploadRendererPrimeFacesImpl((Renderer)renderer);
        } else if (RICHFACES_FILE_UPLOAD_FAMILY.equals(family) && RICHFACES_FILE_UPLOAD_RENDERER_TYPE.equals(rendererType)) {
            renderer = new FileUploadRendererRichFacesImpl((Renderer)renderer);
        }
        return renderer;
    }

    public RenderKit getWrapped() {
        return this.wrappedRenderKit;
    }
}

