/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BaseURLNonEncodedImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;

public class BridgeURLPartialActionImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLPartialActionImpl.class);

    public BridgeURLPartialActionImpl(String uri, String contextPath, String namespace, String currentViewId, BridgeConfig bridgeConfig) throws URISyntaxException {
        super(uri, contextPath, namespace, currentViewId, bridgeConfig);
        this.bridgeURI.setParameter("_jsfBridgeAjax", "true");
    }

    @Override
    public BaseURL toBaseURL() throws MalformedURLException {
        BaseURLNonEncodedImpl baseURL = null;
        String uri = this.bridgeURI.toString();
        if (uri != null) {
            if (uri.startsWith("http")) {
                baseURL = new BaseURLNonEncodedImpl(this.bridgeURI);
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", new Object[]{uri});
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                baseURL = this.createResourceURL(facesContext, this.bridgeURI.getParameterMap());
            }
        } else {
            logger.warn("Unable to encode PartialActionURL for url=[null]");
        }
        return baseURL;
    }

    @Override
    protected String getViewIdParameterName() {
        return this.viewIdResourceParameterName;
    }
}

