/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.BridgeURI;
import com.liferay.faces.bridge.util.internal.URLUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.portlet.faces.Bridge;

public class BridgeURIImpl
implements BridgeURI {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURIImpl.class);
    private static final String RELATIVE_PATH_PREFIX = "../";
    private boolean absolute;
    private Boolean escaped;
    private Boolean external;
    private String fragment;
    private Boolean hierarchical;
    private String host;
    private String namespace;
    private boolean opaque;
    private Map<String, String[]> parameters;
    private String path;
    private Boolean pathRelative;
    private Bridge.PortletPhase portletPhase;
    private int port;
    private Boolean portletScheme;
    private String portletSchemeType;
    private String query;
    private String scheme;
    private String schemeSpecificPart;
    private String stringValue;
    private String userInfo;

    public BridgeURIImpl(String namespace, String uri) throws URISyntaxException {
        this.namespace = namespace;
        URI tempURI = new URI(uri);
        this.absolute = tempURI.isAbsolute();
        this.fragment = tempURI.getFragment();
        this.host = tempURI.getHost();
        this.opaque = tempURI.isOpaque();
        this.port = tempURI.getPort();
        this.path = tempURI.getPath();
        this.query = tempURI.getQuery();
        this.stringValue = uri;
        this.scheme = tempURI.getScheme();
        this.schemeSpecificPart = tempURI.getSchemeSpecificPart();
        this.userInfo = tempURI.getUserInfo();
        this.portletScheme = "portlet".equals(this.scheme);
        if (this.portletScheme.booleanValue()) {
            int portletPos = uri.indexOf("portlet:");
            int queryPos = uri.indexOf(63);
            if (queryPos > 0) {
                this.query = uri.substring(queryPos + 1);
                this.portletSchemeType = uri.substring(portletPos + 8, queryPos);
            } else {
                this.portletSchemeType = uri.substring(portletPos + 8);
            }
        }
    }

    @Override
    public String getContextRelativePath(String contextPath) {
        String contextRelativePath = null;
        if (!this.isExternal(contextPath) && this.path != null && this.path.length() > 0) {
            int contextPathPos = this.path.indexOf(contextPath);
            contextRelativePath = contextPathPos >= 0 ? this.path.substring(contextPathPos + contextPath.length()) : this.path;
        }
        return contextRelativePath;
    }

    @Override
    public String getParameter(String name) {
        Map<String, String[]> parameterMap = this.getParameterMap();
        String[] values = parameterMap.get(name);
        if (values == null) {
            values = parameterMap.get(this.namespace + name);
        }
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.parameters == null) {
            this.parameters = URLUtil.parseParameterMapValuesArray(this.stringValue);
        }
        return this.parameters;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Bridge.PortletPhase getPortletPhase() {
        if (this.portletPhase == null) {
            String uriAsString = this.toString();
            if (uriAsString != null) {
                if (this.portletScheme.booleanValue()) {
                    if (uriAsString.startsWith("portlet:action")) {
                        this.portletPhase = Bridge.PortletPhase.ACTION_PHASE;
                    } else if (uriAsString.startsWith("portlet:render")) {
                        this.portletPhase = Bridge.PortletPhase.RENDER_PHASE;
                    } else if (uriAsString.startsWith("portlet:resource")) {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                    } else {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                        logger.warn("Invalid keyword after 'portlet:' in URI=[{0}]", new Object[]{uriAsString});
                    }
                }
            } else {
                this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                logger.warn("Unable to determine portlet phase in null URI");
            }
        }
        return this.portletPhase;
    }

    @Override
    public String getQuery() {
        if (this.query == null) {
            StringBuilder queryBuilder = new StringBuilder();
            Map<String, String[]> parameterMap = this.getParameterMap();
            Set<Map.Entry<String, String[]>> mapEntries = parameterMap.entrySet();
            boolean firstParam = true;
            for (Map.Entry<String, String[]> mapEntry : mapEntries) {
                String[] values;
                if (firstParam) {
                    firstParam = false;
                } else {
                    queryBuilder.append("&");
                }
                if ((values = mapEntry.getValue()) == null) continue;
                boolean firstValue = true;
                for (String value : values) {
                    if (firstValue) {
                        firstValue = false;
                    } else {
                        queryBuilder.append("&");
                    }
                    queryBuilder.append(mapEntry.getKey());
                    queryBuilder.append("=");
                    queryBuilder.append(value);
                }
            }
            this.query = queryBuilder.toString();
        }
        return this.query;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isEscaped() {
        if (this.escaped == null) {
            this.escaped = Boolean.FALSE;
            if (this.query != null) {
                int ampersandPos = this.query.indexOf("&");
                while (ampersandPos > 0) {
                    String queryPart = this.query.substring(ampersandPos);
                    if (queryPart.startsWith("&amp;")) {
                        this.escaped = Boolean.TRUE;
                        ampersandPos = this.query.indexOf("&", ampersandPos + 1);
                        continue;
                    }
                    this.escaped = Boolean.FALSE;
                    break;
                }
            }
        }
        return this.escaped;
    }

    @Override
    public boolean isExternal(String contextPath) {
        if (this.external == null) {
            this.external = Boolean.TRUE;
            String uriAsString = this.toString();
            if (this.portletScheme.booleanValue()) {
                this.external = Boolean.FALSE;
            } else if (!this.isAbsolute() && (contextPath != null && uriAsString.startsWith(contextPath) || uriAsString.startsWith(RELATIVE_PATH_PREFIX))) {
                this.external = Boolean.FALSE;
            }
            if (uriAsString.startsWith("wsrp_rewrite")) {
                this.external = Boolean.FALSE;
            }
        }
        return this.external;
    }

    @Override
    public boolean isHierarchical() {
        if (this.hierarchical == null) {
            this.hierarchical = Boolean.FALSE;
            if (this.isAbsolute() && this.schemeSpecificPart.startsWith("/") || this.isRelative()) {
                this.hierarchical = Boolean.TRUE;
            }
        }
        return this.hierarchical;
    }

    @Override
    public boolean isOpaque() {
        return this.portletScheme != false || this.opaque;
    }

    @Override
    public boolean isPathRelative() {
        if (this.pathRelative == null) {
            this.pathRelative = Boolean.FALSE;
            String path = this.getPath();
            if (path != null && path.length() > 0 && (!path.startsWith("/") || path.startsWith(RELATIVE_PATH_PREFIX))) {
                this.pathRelative = Boolean.TRUE;
            }
        }
        return this.pathRelative;
    }

    @Override
    public boolean isPortletScheme() {
        return this.portletScheme;
    }

    @Override
    public boolean isRelative() {
        return !this.isAbsolute();
    }

    @Override
    public String removeParameter(String name) {
        String[] values = null;
        Map<String, String[]> parameterMap = this.getParameterMap();
        if (parameterMap.containsKey(name)) {
            values = parameterMap.remove(name);
            this.invalidateToString();
        } else {
            String namespacedParameterName = this.namespace + name;
            if (parameterMap.containsKey(namespacedParameterName)) {
                values = parameterMap.remove(namespacedParameterName);
                this.invalidateToString();
            }
        }
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public void setParameter(String name, String[] values) {
        this.getParameterMap().put(name, values);
        this.invalidateToString();
    }

    @Override
    public void setParameter(String name, String value) {
        this.getParameterMap().put(name, new String[]{value});
        this.invalidateToString();
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            String queryString;
            StringBuilder uriBuilder = new StringBuilder();
            if (this.scheme != null) {
                uriBuilder.append(this.scheme);
                uriBuilder.append(':');
                if (this.portletScheme.booleanValue()) {
                    uriBuilder.append(this.portletSchemeType);
                }
            }
            if (this.userInfo != null || this.host != null || this.port != -1) {
                uriBuilder.append("//");
                if (this.userInfo != null) {
                    uriBuilder.append(this.userInfo);
                    uriBuilder.append('@');
                }
                if (this.host != null) {
                    uriBuilder.append(this.host);
                }
                if (this.port != -1) {
                    uriBuilder.append(':');
                    uriBuilder.append(this.port);
                }
            }
            if (this.path != null) {
                uriBuilder.append(this.path);
            }
            if ((queryString = this.getQuery()) != null && queryString.length() > 0) {
                uriBuilder.append('?');
                uriBuilder.append(queryString);
            }
            if (this.fragment != null) {
                uriBuilder.append('#');
                uriBuilder.append(this.fragment);
            }
            this.stringValue = uriBuilder.toString();
        }
        return this.stringValue;
    }

    private void invalidateToString() {
        this.query = null;
        this.stringValue = null;
    }
}

