/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeConfigFactory;
import com.liferay.faces.bridge.filter.BridgePortletConfigFactory;
import com.liferay.faces.bridge.internal.BridgePhase;
import com.liferay.faces.bridge.internal.BridgePhaseFactory;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeNotAFacesRequestException;
import javax.portlet.faces.BridgeUninitializedException;

public class BridgeImpl
implements Bridge {
    private static final Logger logger = LoggerFactory.getLogger(BridgeImpl.class);
    private boolean initialized = false;
    private PortletConfig portletConfig;

    public void destroy() {
        this.initialized = false;
        try {
            BridgeRequestScopeManager bridgeRequestScopeManager = BridgeRequestScopeManagerFactory.getBridgeRequestScopeManagerInstance();
            bridgeRequestScopeManager.removeBridgeRequestScopesByPortlet(this.portletConfig);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    public void doFacesRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        if (this.initialized) {
            String nonFacesTargetPath = actionRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhase bridgePhase = BridgePhaseFactory.getBridgeActionPhaseInstance(actionRequest, actionResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(EventRequest eventRequest, EventResponse eventResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)eventRequest, (PortletResponse)eventResponse);
        if (this.initialized) {
            String nonFacesTargetPath = eventRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhase bridgePhase = BridgePhaseFactory.getBridgeEventPhaseInstance(eventRequest, eventResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(RenderRequest renderRequest, RenderResponse renderResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (this.initialized) {
            String nonFacesTargetPath = renderRequest.getParameter("_jsfBridgeNonFacesView");
            if (nonFacesTargetPath != null) {
                throw new BridgeNotAFacesRequestException(nonFacesTargetPath);
            }
        } else {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhase bridgePhase = BridgePhaseFactory.getBridgeRenderPhaseInstance(renderRequest, renderResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        PortletConfig wrappedPortletConfig = BridgePortletConfigFactory.getPortletConfigInstance((PortletConfig)this.portletConfig);
        BridgeConfig bridgeConfig = BridgeConfigFactory.getBridgeConfigInstance((PortletConfig)wrappedPortletConfig);
        BridgePhase bridgePhase = BridgePhaseFactory.getBridgeResourcePhaseInstance(resourceRequest, resourceResponse, wrappedPortletConfig, bridgeConfig);
        bridgePhase.execute();
    }

    public String getTitle() {
        return BridgeImpl.class.getPackage().getImplementationTitle();
    }

    public String getVersion() {
        return BridgeImpl.class.getPackage().getImplementationVersion();
    }

    public void init(PortletConfig portletConfig) throws BridgeException {
        StringBuilder logMessage = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");
        GregorianCalendar calendar = new GregorianCalendar();
        String timestamp = dateFormat.format(calendar.getTime());
        logMessage.append(timestamp);
        logMessage.append(" INFO  [BridgeImpl] Initializing ");
        logMessage.append(this.getTitle());
        logMessage.append(" ");
        logMessage.append(this.getVersion());
        System.out.println(logMessage.toString());
        this.initialized = true;
        this.portletConfig = portletConfig;
    }

    protected void checkNull(PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletRequest == null) {
            throw new NullPointerException("portletRequest was null");
        }
        if (portletResponse == null) {
            throw new NullPointerException("portletResponse was null");
        }
    }
}

