/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;

public class BridgeDependencyVerifier {
    private static final Logger logger = LoggerFactory.getLogger(BridgeDependencyVerifier.class);

    public static void verify() {
        Product liferayFacesBridgeExt;
        Package bridgePackage = BridgeDependencyVerifier.class.getPackage();
        String implementationTitle = bridgePackage.getImplementationTitle();
        String implementationVersion = bridgePackage.getImplementationVersion();
        Product liferayPortal = ProductFactory.getProduct((Product.Name)Product.Name.LIFERAY_PORTAL);
        if (liferayPortal.isDetected() && !(liferayFacesBridgeExt = ProductFactory.getProduct((Product.Name)Product.Name.LIFERAY_FACES_BRIDGE_EXT)).isDetected()) {
            logger.error("{0} {1} is running in Liferay Portal {2}.{3} but the com.liferay.faces.bridge.ext.jar dependency is not in the classpath", new Object[]{implementationTitle, implementationVersion, liferayPortal.getMajorVersion(), liferayPortal.getMinorVersion()});
        }
        Product portletApi = ProductFactory.getProduct((Product.Name)Product.Name.PORTLET_API);
        int portletApiMajorVersion = portletApi.getMajorVersion();
        int portletApiMinorVersion = portletApi.getMinorVersion();
        if (portletApiMajorVersion != 2 || portletApiMinorVersion < 0) {
            logger.error("{0} {1} is designed to be used with Portlet 2.0 but detected {2}.{3}", new Object[]{implementationTitle, implementationVersion, portletApiMajorVersion, portletApiMinorVersion});
        }
        Product jsf = ProductFactory.getProduct((Product.Name)Product.Name.JSF);
        int jsfMajorVersion = jsf.getMajorVersion();
        int jsfMinorVersion = jsf.getMinorVersion();
        if (jsfMajorVersion != 2 || jsfMinorVersion != 2) {
            logger.error("{0} {1} is designed to be used with JSF 2.2 but detected {2}.{3}", new Object[]{implementationTitle, implementationVersion, jsfMajorVersion, jsfMinorVersion});
        }
    }
}

