/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.map.internal.SessionScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;

public class SessionScopeMap
extends AbstractPropertyMap<Object> {
    private BeanManager beanManager;
    private PortletSession portletSession;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;
    private int scope;

    public SessionScopeMap(PortletContext portletContext, PortletSession portletSession, int scope, boolean preferPreDestroy) {
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory(PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(portletContext);
        this.portletSession = portletSession;
        this.preferPreDestroy = preferPreDestroy;
        this.scope = scope;
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new SessionScopeMapEntry(this.portletSession, name, this.scope);
    }

    protected Object getProperty(String name) {
        return this.portletSession.getAttribute(name, this.scope);
    }

    protected Enumeration<String> getPropertyNames() {
        return this.portletSession.getAttributeNames(this.scope);
    }

    protected void removeProperty(String name) {
        this.portletSession.removeAttribute(name, this.scope);
    }

    protected void setProperty(String name, Object value) {
        this.portletSession.setAttribute(name, value, this.scope);
    }
}

