/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.map.internal.RequestScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

public class RequestScopeMap
extends AbstractPropertyMap<Object> {
    private BeanManager beanManager;
    private PortletRequest portletRequest;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;
    private Set<String> removedAttributeNames;

    public RequestScopeMap(PortletContext portletContext, PortletRequest portletRequest, Set<String> removedAttributeNames, boolean preferPreDestroy) {
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        this.portletRequest = portletRequest;
        this.preferPreDestroy = preferPreDestroy;
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory(PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(portletContext);
        this.removedAttributeNames = removedAttributeNames == null ? new HashSet<String>() : removedAttributeNames;
    }

    public Object remove(Object key) {
        String keyAsString = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(keyAsString, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new RequestScopeMapEntry(this.portletRequest, name);
    }

    protected Object getProperty(String name) {
        return this.portletRequest.getAttribute(name);
    }

    protected Enumeration<String> getPropertyNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        Enumeration portletRequestAttributeNames = this.portletRequest.getAttributeNames();
        if (portletRequestAttributeNames != null) {
            while (portletRequestAttributeNames.hasMoreElements()) {
                String attributeName = (String)portletRequestAttributeNames.nextElement();
                if (this.removedAttributeNames.contains(attributeName)) continue;
                attributeNames.add(attributeName);
            }
        }
        return Collections.enumeration(attributeNames);
    }

    protected void removeProperty(String name) {
        this.removedAttributeNames.add(name);
        this.portletRequest.removeAttribute(name);
    }

    protected void setProperty(String name, Object value) {
        if (this.removedAttributeNames.contains(name)) {
            this.removedAttributeNames.remove(name);
        }
        this.portletRequest.setAttribute(name, value);
    }
}

