/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.ExternalContextCompat_2_1_Impl;
import com.liferay.faces.util.config.ApplicationConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.Cookie;

public abstract class ExternalContextCompat_2_2_Impl
extends ExternalContextCompat_2_1_Impl {
    private static final String COOKIE_PROPERTY_HTTP_ONLY = "httpOnly";
    private String applicationContextPath;
    private ClientWindow clientWindow;

    public ExternalContextCompat_2_2_Impl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(portletContext, portletRequest, portletResponse);
    }

    @Override
    public String encodeActionURL(String url) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        url = this.encodeClientWindowURL(facesContext, url);
        return super.encodeActionURL(url);
    }

    @Override
    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        baseUrl = this.encodeClientWindowURL(facesContext, baseUrl);
        return super.encodeBookmarkableURL(baseUrl, parameters);
    }

    @Override
    public String encodePartialActionURL(String url) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        url = this.encodeClientWindowURL(facesContext, url);
        return super.encodePartialActionURL(url);
    }

    @Override
    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        baseUrl = this.encodeClientWindowURL(facesContext, baseUrl);
        return super.encodeRedirectURL(baseUrl, parameters);
    }

    public String getApplicationContextPath() {
        if (this.applicationContextPath == null) {
            String appConfigAttrName = ApplicationConfig.class.getName();
            ApplicationConfig applicationConfig = (ApplicationConfig)this.getApplicationMap().get(appConfigAttrName);
            this.applicationContextPath = applicationConfig.getContextPath();
        }
        return this.applicationContextPath;
    }

    public ClientWindow getClientWindow() {
        return this.clientWindow;
    }

    public String getSessionId(boolean create) {
        String sessionId = null;
        PortletSession portletSession = (PortletSession)this.getSession(create);
        sessionId = portletSession == null && !create ? "" : portletSession.getId();
        return sessionId;
    }

    public void setClientWindow(ClientWindow clientWindow) {
        this.clientWindow = clientWindow;
    }

    @Override
    protected Cookie createCookie(String name, String value, Map<String, Object> properties) {
        Boolean httpOnly;
        Cookie cookie = super.createCookie(name, value, properties);
        if (properties != null && !properties.isEmpty() && (httpOnly = (Boolean)properties.get(COOKIE_PROPERTY_HTTP_ONLY)) != null) {
            cookie.setHttpOnly(httpOnly.booleanValue());
        }
        return cookie;
    }

    protected String encodeClientWindowURL(FacesContext facesContext, String url) {
        ClientWindow clientWindow;
        if (url != null && !url.contains("javax.faces.ClientWindow") && (clientWindow = this.getClientWindow()) != null && clientWindow.isClientWindowRenderModeEnabled(facesContext)) {
            StringBuilder urlBuilder = new StringBuilder(url);
            int queryPos = url.indexOf("?");
            if (queryPos > 0) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
            }
            urlBuilder.append("javax.faces.ClientWindow");
            urlBuilder.append("=");
            urlBuilder.append(clientWindow.getId());
            Map queryURLParameters = clientWindow.getQueryURLParameters(facesContext);
            if (queryURLParameters != null && queryURLParameters.size() > 0) {
                Set entrySet = queryURLParameters.entrySet();
                for (Map.Entry mapEntry : entrySet) {
                    urlBuilder.append((String)mapEntry.getKey());
                    urlBuilder.append("=");
                    urlBuilder.append((String)mapEntry.getValue());
                }
            }
            url = urlBuilder.toString();
        }
        return url;
    }
}

