/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.BridgeURLFactory;
import com.liferay.faces.bridge.context.internal.IncongruityContext;
import com.liferay.faces.bridge.internal.BridgeURIFactory;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.BridgeException;

public abstract class ExternalContextBridgeBase
extends ExternalContext {
    protected BridgeConfig bridgeConfig;
    protected BridgeRequestScope bridgeRequestScope;
    protected BridgeURIFactory bridgeURIFactory;
    protected BridgeURLFactory bridgeURLFactory;
    protected List<String> configuredSuffixes;
    protected List<ConfiguredServletMapping> configuredFacesServletMappings;
    protected IncongruityContext incongruityContext;
    protected boolean manageIncongruities;
    protected PortletConfig portletConfig;
    protected PortletContext portletContext;
    protected PortletRequest portletRequest;
    protected PortletResponse portletResponse;

    public ExternalContextBridgeBase(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        this.bridgeConfig = RequestMapUtil.getBridgeConfig(portletRequest);
        this.incongruityContext = (IncongruityContext)((Object)portletRequest.getAttribute(IncongruityContext.class.getName()));
        this.portletConfig = RequestMapUtil.getPortletConfig(portletRequest);
        this.manageIncongruities = PortletConfigParam.ManageIncongruities.getBooleanValue(this.portletConfig);
        this.bridgeRequestScope = (BridgeRequestScope)portletRequest.getAttribute(BridgeRequestScope.class.getName());
        this.bridgeURIFactory = (BridgeURIFactory)BridgeFactoryFinder.getFactory(BridgeURIFactory.class);
        this.bridgeURLFactory = (BridgeURLFactory)BridgeFactoryFinder.getFactory(BridgeURLFactory.class);
        this.configuredFacesServletMappings = (List)this.bridgeConfig.getAttributes().get("configuredFacesServletMappings");
        this.configuredSuffixes = (List)this.bridgeConfig.getAttributes().get("configuredSuffixes");
    }

    public String encodeActionURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL bridgeActionURL = this.bridgeURLFactory.getBridgeActionURL(facesContext, url);
            return bridgeActionURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }
}

