/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.MissingResourceImpl;
import com.liferay.faces.bridge.application.internal.ResourceHandlerBridgeCompatImpl;
import com.liferay.faces.bridge.application.internal.ResourceImpl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public abstract class ResourceHandlerBridgeImpl
extends ResourceHandlerBridgeCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerBridgeImpl.class);
    private Integer bufferSize;
    private ResourceHandler wrappedResourceHandler;

    public ResourceHandlerBridgeImpl(ResourceHandler wrappedResourceHandler) {
        this.wrappedResourceHandler = wrappedResourceHandler;
    }

    public Resource createResource(String resourceName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName, contentType);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName, contentType);
        }
        return new ResourceImpl(wrappableResource);
    }

    public ResourceHandler getWrapped() {
        return this.wrappedResourceHandler;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceName = (String)requestParameterMap.get("javax.faces.resource");
        if (resourceName != null) {
            String libraryName = (String)requestParameterMap.get("ln");
            if (logger.isTraceEnabled()) {
                logger.trace("Handling - resourceName=[{0}], libraryName[{1}]", new Object[]{resourceName, libraryName});
            }
            ResourceHandler resourceHandlerChain = facesContext.getApplication().getResourceHandler();
            Resource resource = libraryName == null ? resourceHandlerChain.createResource(resourceName) : resourceHandlerChain.createResource(resourceName, libraryName);
            this.handleResource(facesContext, externalContext, resource);
        } else {
            logger.debug("NOT HANDLED - Missing request parameter {0} so delegating handleResourceRequest to chain", new Object[]{"javax.faces.resource"});
            this.getWrapped().handleResourceRequest(facesContext);
        }
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceId = (String)requestParameterMap.get("javax.faces.resource");
        if (resourceId != null) {
            logger.debug("Found {0} request parameter and recognized resourceId=[{1}] as a resource", new Object[]{"javax.faces.resource", resourceId});
            return true;
        }
        logger.debug("Did not find the {0} request parameter so delegating isResourceRequest to chain", new Object[]{"javax.faces.resource"});
        return this.getWrapped().isResourceRequest(facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleResource(FacesContext facesContext, ExternalContext externalContext, Resource resource) throws IOException {
        boolean needsUpdate = resource.userAgentNeedsUpdate(facesContext);
        if (!this.isAbleToSetHttpStatusCode(facesContext) && !needsUpdate) {
            needsUpdate = true;
            logger.debug("Unable to set the status code to HttpServletResponse.SC_NOT_MODIFIED ({0}) for resourceName=[{1}]", new Object[]{304, resource.getResourceName()});
        }
        if (needsUpdate) {
            logger.trace("Handling - Resource was either modified or has not yet been downloaded.");
            Channel readableByteChannel = null;
            Channel writableByteChannel = null;
            InputStream inputStream = null;
            if (this.bufferSize == null) {
                PortletConfig portletConfig = RequestMapUtil.getPortletConfig(facesContext);
                this.bufferSize = PortletConfigParam.ResourceBufferSize.getIntegerValue(portletConfig);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.bufferSize);
            try {
                inputStream = resource.getInputStream();
                if (inputStream != null) {
                    Map responseHeaderMap = resource.getResponseHeaders();
                    if (responseHeaderMap != null) {
                        for (Map.Entry mapEntry : responseHeaderMap.entrySet()) {
                            String name = (String)mapEntry.getKey();
                            String value = (String)mapEntry.getValue();
                            externalContext.setResponseHeader(name, value);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Handling - COPIED resource header name=[{0}] value=[{1}]", new Object[]{name, value});
                        }
                    }
                    String responseContentType = resource.getContentType();
                    logger.trace("Handling - responseContentType=[{0}]", new Object[]{responseContentType});
                    if (responseContentType != null) {
                        externalContext.setResponseContentType(responseContentType);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.bufferSize);
                    int responseContentLength = 0;
                    readableByteChannel = Channels.newChannel(inputStream);
                    writableByteChannel = Channels.newChannel(byteArrayOutputStream);
                    int bytesRead = readableByteChannel.read(byteBuffer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Handling - bytesRead=[{0}]", new Object[]{Integer.toString(bytesRead)});
                    }
                    int bytesWritten = 0;
                    while (bytesRead != -1) {
                        byteBuffer.rewind();
                        byteBuffer.limit(bytesRead);
                        while ((bytesWritten += writableByteChannel.write(byteBuffer)) < responseContentLength) {
                        }
                        byteBuffer.clear();
                        responseContentLength += bytesRead;
                        bytesRead = readableByteChannel.read(byteBuffer);
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Handling - MORE bytesRead=[{0}]", new Object[]{Integer.toString(bytesRead)});
                    }
                    responseContentLength = byteArrayOutputStream.size();
                    externalContext.setResponseContentLength(responseContentLength);
                    externalContext.setResponseStatus(200);
                    externalContext.setResponseBufferSize(responseContentLength);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Handling - responseBufferSize=[{0}]", new Object[]{Integer.toString(responseContentLength)});
                    }
                    byteArrayOutputStream.writeTo(externalContext.getResponseOutputStream());
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("HANDLED (SC_OK) resourceName=[{0}], libraryName[{1}], responseContentType=[{4}], responseContentLength=[{5}]", new Object[]{resource.getResourceName(), resource.getLibraryName(), responseContentType, responseContentLength});
                    return;
                }
                externalContext.setResponseStatus(404);
                logger.error("NOT HANDLED (SC_NOT_FOUND) because InputStream was null - resourceName=[{0}], libraryName[{1}]", new Object[]{resource.getResourceName(), resource.getLibraryName()});
                return;
            }
            catch (IOException e) {
                externalContext.setResponseStatus(404);
                logger.error("NOT HANDLED (SC_NOT_FOUND) resourceName=[{0}], libraryName[{1}], errorMessage=[{4}]", new Object[]{new Object[]{resource.getResourceName(), resource.getLibraryName(), e.getMessage()}, e});
                return;
            }
            finally {
                if (writableByteChannel != null) {
                    writableByteChannel.close();
                }
                if (readableByteChannel != null) {
                    readableByteChannel.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } else {
            externalContext.setResponseStatus(304);
            if (!logger.isDebugEnabled()) return;
            logger.debug("HANDLED (SC_NOT_MODIFIED) resourceName=[{0}], libraryName[{1}]", new Object[]{resource.getResourceName(), resource.getLibraryName()});
        }
    }

    private boolean isAbleToSetHttpStatusCode(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        String setHttpStatusCodeSupport = portalContext.getProperty("com.liferay.faces.bridge.set.http.status.code.support");
        return setHttpStatusCodeSupport != null;
    }
}

