/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.richfaces.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.richfaces.internal.RichFacesUploadedFileHandler;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import com.liferay.faces.util.render.RendererWrapper;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

public class FileUploadRendererRichFacesImpl
extends RendererWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadRendererRichFacesImpl.class);
    private static final String RICHFACES_UPLOADED_FILE_FQCN = "org.richfaces.model.UploadedFile";
    private static final String RICHFACES_FILE_UPLOAD_EVENT_FQCN = "org.richfaces.event.FileUploadEvent";
    private static final Product RICHFACES = ProductFactory.getProduct((Product.Name)Product.Name.RICHFACES);
    private static final boolean FACES_2638 = RICHFACES.isDetected() && RICHFACES.getMajorVersion() == 4 && RICHFACES.getMinorVersion() == 5 && RICHFACES.getPatchVersion() >= 16;
    private Renderer wrappedRenderer;

    public FileUploadRendererRichFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        try {
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletContext portletContext = (PortletContext)externalContext.getContext();
            ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ContextMapFactory.class);
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            Map<String, List<UploadedFile>> uploadedFileMap = contextMapFactory.getUploadedFileMap(portletRequest);
            if (uploadedFileMap != null) {
                Class<?> uploadedFileInterface = Class.forName(RICHFACES_UPLOADED_FILE_FQCN);
                Class<?> fileUploadEventClass = Class.forName(RICHFACES_FILE_UPLOAD_EVENT_FQCN);
                ClassLoader classLoader = uploadedFileInterface.getClassLoader();
                String clientId = uiComponent.getClientId(facesContext);
                List<UploadedFile> uploadedFiles = uploadedFileMap.get(clientId);
                if (uploadedFiles != null) {
                    for (UploadedFile uploadedFile : uploadedFiles) {
                        RichFacesUploadedFileHandler richFacesUploadedFileHandler = new RichFacesUploadedFileHandler(uploadedFile);
                        Object richFacesUploadedFile = Proxy.newProxyInstance(classLoader, new Class[]{uploadedFileInterface}, (InvocationHandler)richFacesUploadedFileHandler);
                        FacesEvent fileUploadEvent = (FacesEvent)fileUploadEventClass.getConstructor(UIComponent.class, uploadedFileInterface).newInstance(uiComponent, richFacesUploadedFile);
                        uiComponent.queueEvent(fileUploadEvent);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (FACES_2638) {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            requestMap.put("FACES-2638", Boolean.TRUE);
            super.encodeEnd(facesContext, uiComponent);
            requestMap.remove("FACES-2638");
        } else {
            super.encodeEnd(facesContext, uiComponent);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

