/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.BridgeURLFactory;
import com.liferay.faces.bridge.component.primefaces.internal.PrimeFacesFileUpload;
import com.liferay.faces.bridge.renderkit.primefaces.internal.ResponseWriterPrimeFacesBodyImpl;
import com.liferay.faces.util.render.RendererWrapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionListener;
import javax.faces.render.Renderer;
import javax.portlet.PortletContext;
import javax.portlet.faces.BridgeException;

public class FormRendererPrimeFacesImpl
extends RendererWrapper {
    private static final String P_DATA_EXPORTER_FQCN = "org.primefaces.component.export.DataExporter";
    private static final String P_FILE_DOWNLOAD_FQCN = "org.primefaces.component.filedownload.FileDownloadActionListener";
    private static final String PE_EXPORTER_FQCN = "org.primefaces.extensions.component.exporter.DataExporter";
    private int majorVersion;
    private int minorVersion;
    private Renderer wrappedRenderer;

    public FormRendererPrimeFacesImpl(int majorVersion, int minorVersion, Renderer renderer) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.wrappedRenderer = renderer;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.majorVersion == 3 && this.minorVersion < 3 && this.isMultiPartForm(uiComponent)) {
            PrimeFacesFileUpload primeFacesFileUpload;
            boolean hasPrimeFacesAjaxFileUploadChild = false;
            UIComponent childComponent = this.getChildWithRendererType(uiComponent, "org.primefaces.component.FileUploadRenderer");
            if (childComponent != null && !(primeFacesFileUpload = new PrimeFacesFileUpload((UIInput)childComponent)).getMode().equals("simple")) {
                hasPrimeFacesAjaxFileUploadChild = true;
                facesContext.getAttributes().put("ajax.file.upload", Boolean.TRUE);
            }
            super.encodeBegin(facesContext, uiComponent);
            if (hasPrimeFacesAjaxFileUploadChild) {
                facesContext.getAttributes().remove("ajax.file.upload");
            }
        } else if (this.hasNonAjaxActionListener(uiComponent)) {
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String viewId = facesContext.getViewRoot().getViewId();
            String facesActionURL = viewHandler.getActionURL(facesContext, viewId);
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletContext portletContext = (PortletContext)externalContext.getContext();
            BridgeURLFactory bridgeURLFactory = (BridgeURLFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BridgeURLFactory.class);
            try {
                BridgeURL partialActionURL = bridgeURLFactory.getBridgePartialActionURL(facesContext, facesActionURL);
                partialActionURL.getParameterMap().remove("_jsfBridgeAjax");
                String nonAjaxPartialActionURL = partialActionURL.toString();
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                ResponseWriterPrimeFacesBodyImpl primeFacesResponseWriter = new ResponseWriterPrimeFacesBodyImpl(responseWriter, nonAjaxPartialActionURL);
                facesContext.setResponseWriter((ResponseWriter)primeFacesResponseWriter);
                super.encodeBegin(facesContext, uiComponent);
                facesContext.setResponseWriter(responseWriter);
            }
            catch (BridgeException e) {
                e.printStackTrace();
            }
        } else {
            super.encodeBegin(facesContext, uiComponent);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    protected UIComponent getChildWithRendererType(UIComponent uiComponent, String rendererType) {
        UIComponent childWithRendererType = null;
        List children = uiComponent.getChildren();
        if (children != null) {
            for (UIComponent uiComponentChild : children) {
                if (rendererType.equals(uiComponentChild.getRendererType())) {
                    childWithRendererType = uiComponentChild;
                    break;
                }
                childWithRendererType = this.getChildWithRendererType(uiComponentChild, rendererType);
                if (childWithRendererType == null) continue;
                break;
            }
        }
        return childWithRendererType;
    }

    protected boolean hasNonAjaxActionListener(UIComponent uiComponent) {
        boolean nonAjaxActionListener = false;
        Iterator facetsAndChildren = uiComponent.getFacetsAndChildren();
        if (facetsAndChildren != null) {
            while (facetsAndChildren.hasNext()) {
                ActionSource actionSource;
                ActionListener[] actionListeners;
                UIComponent facetOrChild = (UIComponent)facetsAndChildren.next();
                if (facetOrChild instanceof ActionSource && (actionListeners = (actionSource = (ActionSource)facetOrChild).getActionListeners()) != null) {
                    for (ActionListener actionListener : actionListeners) {
                        String actionListenerFQCN = actionListener.getClass().getName();
                        if (!P_DATA_EXPORTER_FQCN.equals(actionListenerFQCN) && !P_FILE_DOWNLOAD_FQCN.equals(actionListenerFQCN) && !PE_EXPORTER_FQCN.equals(actionListenerFQCN)) continue;
                        nonAjaxActionListener = true;
                        break;
                    }
                }
                if (nonAjaxActionListener) continue;
                nonAjaxActionListener = this.hasNonAjaxActionListener(facetOrChild);
            }
        }
        return nonAjaxActionListener;
    }

    protected boolean isMultiPartForm(UIComponent uiComponent) {
        String enctype = (String)uiComponent.getAttributes().get("enctype");
        return enctype != null && enctype.toLowerCase().contains("multipart");
    }
}

