/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.component.internal.ComponentUtil;
import com.liferay.faces.bridge.context.HeadResponseWriterFactory;
import com.liferay.faces.bridge.renderkit.html_basic.internal.InlineScript;
import com.liferay.faces.bridge.renderkit.html_basic.internal.RenderKitUtil;
import com.liferay.faces.util.application.ResourceUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class HeadRendererBridgeImpl
extends Renderer {
    private static final String FIRST_FACET = "first";
    private static final String MIDDLE_FACET = "middle";
    private static final String LAST_FACET = "last";
    private static final Logger logger = LoggerFactory.getLogger(HeadRendererBridgeImpl.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        List<UIComponent> lastResources;
        List<UIComponent> middleResources;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        ArrayList<Object> headResources = new ArrayList<Object>();
        List<UIComponent> firstResources = this.getFirstResources(facesContext, uiComponent);
        if (firstResources != null) {
            headResources.addAll(firstResources);
        }
        List headComponentResources = uiViewRoot.getComponentResources(facesContext, "head");
        ArrayList<UIComponent> styleSheetResources = new ArrayList<UIComponent>();
        ArrayList<UIComponent> scriptResources = new ArrayList<UIComponent>();
        ArrayList<UIComponent> otherHeadResources = new ArrayList<UIComponent>();
        for (UIComponent headComponentResource : headComponentResources) {
            if (RenderKitUtil.isStyleSheetResource(headComponentResource) || this.isInlineStyleSheet(headComponentResource)) {
                styleSheetResources.add(headComponentResource);
                continue;
            }
            if (RenderKitUtil.isScriptResource(headComponentResource) || this.isInlineScript(headComponentResource)) {
                scriptResources.add(headComponentResource);
                continue;
            }
            otherHeadResources.add(headComponentResource);
        }
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (RenderKitUtil.isStyleSheetResource(child) || this.isInlineStyleSheet(child)) {
                styleSheetResources.add(child);
                continue;
            }
            if (RenderKitUtil.isScriptResource(child) || this.isInlineScript(child)) {
                scriptResources.add(child);
                continue;
            }
            otherHeadResources.add(child);
        }
        if (!otherHeadResources.isEmpty()) {
            headResources.addAll(otherHeadResources);
        }
        if (!styleSheetResources.isEmpty()) {
            headResources.addAll(styleSheetResources);
        }
        if ((middleResources = this.getMiddleResources(facesContext, uiComponent)) != null) {
            headResources.addAll(middleResources);
        }
        if (!scriptResources.isEmpty()) {
            headResources.addAll(scriptResources);
        }
        if ((lastResources = this.getLastResources(facesContext, uiComponent)) != null) {
            headResources.addAll(lastResources);
        }
        ArrayList<UIComponent> headResourcesToRenderInBody = new ArrayList<UIComponent>();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        Iterator iterator = headResources.iterator();
        while (iterator.hasNext()) {
            UIComponent headResource = (UIComponent)iterator.next();
            if (this.ableToAddResourceToHead(portalContext, headResource)) continue;
            headResourcesToRenderInBody.add(headResource);
            iterator.remove();
            if (!logger.isDebugEnabled()) continue;
            Map componentResourceAttributes = headResource.getAttributes();
            logger.debug("Relocating resource to body: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", new Object[]{componentResourceAttributes.get("name"), componentResourceAttributes.get("library"), headResource.getRendererType(), ComponentUtil.getComponentValue(headResource), headResource.getClass().getName()});
        }
        Map facesContextAttributes = facesContext.getAttributes();
        facesContextAttributes.put("headResourcesToRenderInBody", headResourcesToRenderInBody);
        if (!headResources.isEmpty()) {
            ResponseWriter responseWriterBackup = facesContext.getResponseWriter();
            ResponseWriter headResponseWriter = (ResponseWriter)portletRequest.getAttribute("com.liferay.faces.bridge.HeadResponseWriter");
            if (headResponseWriter == null) {
                PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
                PortletContext portletContext = (PortletContext)externalContext.getContext();
                headResponseWriter = HeadResponseWriterFactory.getHeadResponseWriterInstance((ResponseWriter)responseWriterBackup, (PortletContext)portletContext, (PortletResponse)portletResponse);
            }
            portletRequest.setAttribute("com.liferay.faces.bridge.HeadResponseWriter", (Object)headResponseWriter);
            facesContext.setResponseWriter(headResponseWriter);
            Set<String> headResourceIds = RenderKitUtil.getHeadResourceIds(facesContext);
            for (UIComponent uIComponent : headResources) {
                uIComponent.encodeAll(facesContext);
                if (!RenderKitUtil.isScriptResource(uIComponent) && !RenderKitUtil.isStyleSheetResource(uIComponent)) continue;
                headResourceIds.add(ResourceUtil.getResourceId((UIComponent)uIComponent));
            }
            facesContext.setResponseWriter(responseWriterBackup);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected List<UIComponent> getFirstResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(FIRST_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    protected List<UIComponent> getLastResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(LAST_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    protected List<UIComponent> getMiddleResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(MIDDLE_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    private boolean ableToAddResourceToHead(PortalContext portalContext, UIComponent componentResource) {
        if (RenderKitUtil.isStyleSheetResource(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.style.sheet.resource.to.head.support") != null;
        }
        if (RenderKitUtil.isScriptResource(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.script.resource.to.head.support") != null;
        }
        if (this.isInlineStyleSheet(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.style.sheet.text.to.head.support") != null;
        }
        if (this.isInlineScript(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.script.text.to.head.support") != null;
        }
        return portalContext.getProperty("com.liferay.faces.bridge.add.element.to.head.support") != null;
    }

    private boolean isInlineScript(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String rendererType = componentResource.getRendererType();
        return componentResource instanceof InlineScript || resourceName == null && ("javax.faces.resource.Script".equals(rendererType) || rendererType != null && rendererType.startsWith("com.liferay.faces.") && rendererType.endsWith(".component.outputscript.OutputScriptRenderer"));
    }

    private boolean isInlineStyleSheet(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String rendererType = componentResource.getRendererType();
        return resourceName == null && ("javax.faces.resource.Stylesheet".equals(rendererType) || rendererType != null && rendererType.startsWith("com.liferay.faces.") && rendererType.endsWith(".component.outputstylesheet.OutputStylesheetRenderer"));
    }
}

