/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BaseURLNonEncodedImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.PortletConfig;

public class BridgeURLPartialActionImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLPartialActionImpl.class);

    public BridgeURLPartialActionImpl(String uri, String contextPath, String namespace, String currentViewId, boolean clientWindowEnabled, String clientWindowId, Map<String, String> clientWindowParameters, PortletConfig portletConfig, BridgeConfig bridgeConfig) throws URISyntaxException {
        super(uri, contextPath, namespace, currentViewId, portletConfig, bridgeConfig);
        if (clientWindowEnabled && clientWindowId != null && uri != null && !uri.contains("jfwid")) {
            this.bridgeURI.setParameter("jfwid", clientWindowId);
            if (clientWindowParameters != null) {
                this.bridgeURI.setParameters(clientWindowParameters);
            }
        }
        this.bridgeURI.setParameter("_jsfBridgeAjax", "true");
    }

    @Override
    public BaseURL toBaseURL(FacesContext facesContext) throws MalformedURLException {
        BaseURLNonEncodedImpl baseURL = null;
        String uri = ((Object)this.bridgeURI).toString();
        if (uri != null) {
            if (uri.startsWith("http")) {
                baseURL = new BaseURLNonEncodedImpl(this.bridgeURI);
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", new Object[]{uri});
            } else {
                baseURL = this.createResourceURL(facesContext, this.bridgeURI.getParameterMap());
            }
        } else {
            logger.warn("Unable to encode PartialActionURL for url=[null]");
        }
        return baseURL;
    }

    @Override
    protected String getViewIdParameterName() {
        return this.viewIdResourceParameterName;
    }
}

