/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.BridgeURLFactory;
import com.liferay.faces.bridge.internal.BridgeDependencyVerifier;
import com.liferay.faces.bridge.internal.BridgeURLActionImpl;
import com.liferay.faces.bridge.internal.BridgeURLBookmarkableImpl;
import com.liferay.faces.bridge.internal.BridgeURLPartialActionImpl;
import com.liferay.faces.bridge.internal.BridgeURLRedirectImpl;
import com.liferay.faces.bridge.internal.BridgeURLResourceImpl;
import com.liferay.faces.bridge.internal.ClientWindowInfo;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.faces.BridgeException;

public class BridgeURLFactoryImpl
extends BridgeURLFactory
implements Serializable {
    private static final long serialVersionUID = 4036112087598188923L;

    public BridgeURLFactoryImpl() {
        BridgeDependencyVerifier.verify();
    }

    public BridgeURL getBridgeActionURL(FacesContext facesContext, String uri) throws BridgeException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ContextInfo contextInfo = new ContextInfo(facesContext.getViewRoot(), externalContext);
        ClientWindowInfo clientWindowInfo = new ClientWindowInfo(externalContext);
        try {
            return new BridgeURLActionImpl(uri, contextInfo.contextPath, contextInfo.namespace, contextInfo.currentFacesViewId, clientWindowInfo.isRenderModeEnabled(facesContext), clientWindowInfo.getId(), clientWindowInfo.getUrlParameters(facesContext), contextInfo.portletConfig, contextInfo.bridgeConfig);
        }
        catch (URISyntaxException e) {
            throw new BridgeException((Exception)e);
        }
    }

    public BridgeURL getBridgeBookmarkableURL(FacesContext facesContext, String uri, Map<String, List<String>> parameters) throws BridgeException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ContextInfo contextInfo = new ContextInfo(facesContext.getViewRoot(), externalContext);
        ClientWindowInfo clientWindowInfo = new ClientWindowInfo(externalContext);
        try {
            return new BridgeURLBookmarkableImpl(uri, contextInfo.contextPath, contextInfo.namespace, contextInfo.currentFacesViewId, parameters, clientWindowInfo.isRenderModeEnabled(facesContext), clientWindowInfo.getId(), clientWindowInfo.getUrlParameters(facesContext), contextInfo.portletConfig, contextInfo.bridgeConfig);
        }
        catch (URISyntaxException e) {
            throw new BridgeException((Exception)e);
        }
    }

    public BridgeURL getBridgePartialActionURL(FacesContext facesContext, String uri) throws BridgeException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ContextInfo contextInfo = new ContextInfo(facesContext.getViewRoot(), externalContext);
        try {
            ClientWindowInfo clientWindowInfo = new ClientWindowInfo(externalContext);
            return new BridgeURLPartialActionImpl(uri, contextInfo.contextPath, contextInfo.namespace, contextInfo.currentFacesViewId, clientWindowInfo.isRenderModeEnabled(facesContext), clientWindowInfo.getId(), clientWindowInfo.getUrlParameters(facesContext), contextInfo.portletConfig, contextInfo.bridgeConfig);
        }
        catch (URISyntaxException e) {
            throw new BridgeException((Exception)e);
        }
    }

    public BridgeURL getBridgeRedirectURL(FacesContext facesContext, String uri, Map<String, List<String>> parameters) throws BridgeException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ContextInfo contextInfo = new ContextInfo(facesContext.getViewRoot(), externalContext);
        ClientWindowInfo clientWindowInfo = new ClientWindowInfo(externalContext);
        try {
            return new BridgeURLRedirectImpl(uri, contextInfo.contextPath, contextInfo.namespace, parameters, clientWindowInfo.isRenderModeEnabled(facesContext), clientWindowInfo.getId(), clientWindowInfo.getUrlParameters(facesContext), contextInfo.portletConfig, contextInfo.bridgeConfig);
        }
        catch (URISyntaxException e) {
            throw new BridgeException((Exception)e);
        }
    }

    public BridgeURL getBridgeResourceURL(FacesContext facesContext, String uri) throws BridgeException {
        ContextInfo contextInfo = new ContextInfo(facesContext.getViewRoot(), facesContext.getExternalContext());
        try {
            return new BridgeURLResourceImpl(facesContext, uri, contextInfo.contextPath, contextInfo.namespace, contextInfo.currentFacesViewId, contextInfo.portletConfig, contextInfo.bridgeConfig);
        }
        catch (URISyntaxException e) {
            throw new BridgeException((Exception)e);
        }
    }

    public BridgeURLFactory getWrapped() {
        return null;
    }

    private static class ContextInfo {
        public BridgeConfig bridgeConfig;
        public String contextPath;
        public String currentFacesViewId;
        public String namespace;
        public PortletConfig portletConfig;

        public ContextInfo(UIViewRoot uiViewRoot, ExternalContext externalContext) {
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            this.bridgeConfig = RequestMapUtil.getBridgeConfig(portletRequest);
            this.contextPath = externalContext.getRequestContextPath();
            if (uiViewRoot != null) {
                this.currentFacesViewId = uiViewRoot.getViewId();
            }
            this.namespace = externalContext.encodeNamespace("");
            this.portletConfig = RequestMapUtil.getPortletConfig(portletRequest);
        }
    }
}

