/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeCache;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRequestScopeCacheImpl
extends ConcurrentHashMap<String, BridgeRequestScope>
implements BridgeRequestScopeCache {
    private static final long serialVersionUID = 4546189667853367660L;
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeCacheImpl.class);
    private int maxSize;

    public BridgeRequestScopeCacheImpl(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public BridgeRequestScope put(String bridgeRequestScopeId, BridgeRequestScope bridgeRequestScope) {
        if (this.maxSize != -1 && super.size() > this.maxSize) {
            BridgeRequestScope eldestBridgeRequestScope = null;
            long oldestDate = bridgeRequestScope.getDateCreated();
            Set entrySet = super.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                BridgeRequestScope currentBridgeRequestScope = (BridgeRequestScope)mapEntry.getValue();
                if (currentBridgeRequestScope.getDateCreated() >= oldestDate) continue;
                eldestBridgeRequestScope = currentBridgeRequestScope;
            }
            if (eldestBridgeRequestScope != null) {
                String eldestBridgeRequestScopeId = eldestBridgeRequestScope.getId();
                super.remove(eldestBridgeRequestScopeId);
                logger.debug("Exceeded threshold of [{0}] for [{1}], removed eldest bridgeRequestScope id=[{2}]", new Object[]{this.maxSize, "javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES", eldestBridgeRequestScopeId});
            }
        }
        return super.put(bridgeRequestScopeId, bridgeRequestScope);
    }
}

