/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.component.primefaces.internal.PrimeFacesFileUpload;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.primefaces.internal.PrimeFacesFileItem;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererWrapper;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import javax.portlet.PortletRequest;
import org.apache.commons.fileupload.FileItem;

public class FileUploadRendererPrimeFacesImpl
extends RendererWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadRendererPrimeFacesImpl.class);
    private static final String FQCN_DEFAULT_UPLOADED_FILE = "org.primefaces.model.DefaultUploadedFile";
    private static final String FQCN_FILE_UPLOAD_EVENT = "org.primefaces.event.FileUploadEvent";
    private static final String FQCN_UPLOADED_FILE = "org.primefaces.model.UploadedFile";
    private Renderer wrappedRenderer;

    public FileUploadRendererPrimeFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        try {
            PortletRequest portletRequest;
            ContextMapFactory contextMapFactory;
            Map<String, List<UploadedFile>> uploadedFileMap;
            List<UploadedFile> uploadedFiles;
            String clientId = uiComponent.getClientId(facesContext);
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String submittedValue = (String)requestParameterMap.get(clientId);
            if (submittedValue != null && (uploadedFiles = (uploadedFileMap = (contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class)).getUploadedFileMap(portletRequest = (PortletRequest)externalContext.getRequest())).get(clientId)) != null) {
                for (UploadedFile uploadedFile : uploadedFiles) {
                    PrimeFacesFileItem fileItem = new PrimeFacesFileItem(clientId, uploadedFile);
                    Class<?> defaultUploadedFileClass = Class.forName(FQCN_DEFAULT_UPLOADED_FILE);
                    Constructor<?> constructor = defaultUploadedFileClass.getDeclaredConstructor(FileItem.class);
                    Object defaultUploadedFile = constructor.newInstance(fileItem);
                    PrimeFacesFileUpload primeFacesFileUpload = new PrimeFacesFileUpload((UIInput)uiComponent);
                    if (primeFacesFileUpload.getMode().equals("simple")) {
                        logger.debug("Setting submittedValue=[{0}]", new Object[]{submittedValue});
                        primeFacesFileUpload.setSubmittedValue(defaultUploadedFile);
                        continue;
                    }
                    logger.debug("Queuing FileUploadEvent for submittedValue=[{0}]", new Object[]{submittedValue});
                    Class<?> uploadedFileClass = Class.forName(FQCN_UPLOADED_FILE);
                    Class<?> fileUploadEventClass = Class.forName(FQCN_FILE_UPLOAD_EVENT);
                    constructor = fileUploadEventClass.getConstructor(UIComponent.class, uploadedFileClass);
                    FacesEvent fileUploadEvent = (FacesEvent)constructor.newInstance(uiComponent, defaultUploadedFile);
                    primeFacesFileUpload.queueEvent(fileUploadEvent);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

