/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.component.internal.ComponentUtil;
import com.liferay.faces.bridge.context.HeadResponseWriterFactory;
import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadManagedBean;
import com.liferay.faces.util.application.ResourceUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.PortalContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadRendererBridgeImpl
extends Renderer {
    static final String HEAD_RESOURCES_TO_RENDER_IN_BODY = "headResourcesToRenderInBody";
    private static final String FIRST_FACET = "first";
    private static final String MIDDLE_FACET = "middle";
    private static final String LAST_FACET = "last";
    private static final Logger logger = LoggerFactory.getLogger(HeadRendererBridgeImpl.class);

    static boolean isScriptResource(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        return resourceName != null && resourceName.endsWith("js");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        List<UIComponent> lastResources;
        List<UIComponent> middleResources;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        ArrayList<Object> headResources = new ArrayList<Object>();
        List<UIComponent> firstResources = this.getFirstResources(facesContext, uiComponent);
        if (firstResources != null) {
            headResources.addAll(firstResources);
        }
        List headComponentResources = uiViewRoot.getComponentResources(facesContext, "head");
        ArrayList<UIComponent> styleSheetResources = new ArrayList<UIComponent>();
        ArrayList<UIComponent> scriptResources = new ArrayList<UIComponent>();
        for (UIComponent headComponentResource : headComponentResources) {
            if (this.isStyleSheetResource(headComponentResource) || this.isInlineStyleSheet(headComponentResource)) {
                styleSheetResources.add(headComponentResource);
                continue;
            }
            scriptResources.add(headComponentResource);
        }
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (this.isStyleSheetResource(child) || this.isInlineStyleSheet(child)) {
                styleSheetResources.add(child);
                continue;
            }
            if (!HeadRendererBridgeImpl.isScriptResource(child) && !this.isInlineScript(child)) continue;
            scriptResources.add(child);
        }
        if (!styleSheetResources.isEmpty()) {
            headResources.addAll(styleSheetResources);
        }
        if ((middleResources = this.getMiddleResources(facesContext, uiComponent)) != null) {
            headResources.addAll(middleResources);
        }
        if (!scriptResources.isEmpty()) {
            headResources.addAll(scriptResources);
        }
        if ((lastResources = this.getLastResources(facesContext, uiComponent)) != null) {
            headResources.addAll(lastResources);
        }
        ArrayList<UIComponent> headResourcesToRenderInBody = new ArrayList<UIComponent>();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        Iterator iterator = headResources.iterator();
        while (iterator.hasNext()) {
            UIComponent headResource = (UIComponent)iterator.next();
            if (this.ableToAddResourceToHead(portalContext, headResource)) continue;
            headResourcesToRenderInBody.add(headResource);
            iterator.remove();
            if (!logger.isDebugEnabled()) continue;
            Map componentResourceAttributes = headResource.getAttributes();
            logger.debug("Relocating resource to body: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", new Object[]{componentResourceAttributes.get("name"), componentResourceAttributes.get("library"), headResource.getRendererType(), ComponentUtil.getComponentValue(headResource), headResource.getClass().getName()});
        }
        Map facesContextAttributes = facesContext.getAttributes();
        facesContextAttributes.put(HEAD_RESOURCES_TO_RENDER_IN_BODY, headResourcesToRenderInBody);
        if (!headResources.isEmpty()) {
            ResponseWriter responseWriterBackup = facesContext.getResponseWriter();
            ResponseWriter headResponseWriter = (ResponseWriter)portletRequest.getAttribute("com.liferay.faces.bridge.HeadResponseWriter");
            if (headResponseWriter == null) {
                PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
                headResponseWriter = HeadResponseWriterFactory.getHeadResponseWriterInstance((ResponseWriter)responseWriterBackup, (PortletResponse)portletResponse);
            }
            portletRequest.setAttribute("com.liferay.faces.bridge.HeadResponseWriter", (Object)headResponseWriter);
            facesContext.setResponseWriter(headResponseWriter);
            HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
            Set<String> headResourceIds = headManagedBean == null ? new HashSet<String>() : headManagedBean.getHeadResourceIds();
            for (UIComponent uIComponent : headResources) {
                uIComponent.encodeAll(facesContext);
                if (!HeadRendererBridgeImpl.isScriptResource(uIComponent) && !this.isStyleSheetResource(uIComponent)) continue;
                headResourceIds.add(ResourceUtil.getResourceId((UIComponent)uIComponent));
            }
            facesContext.setResponseWriter(responseWriterBackup);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected List<UIComponent> getFirstResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(FIRST_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    protected List<UIComponent> getLastResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(LAST_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    protected List<UIComponent> getMiddleResources(FacesContext facesContext, UIComponent uiComponent) {
        ArrayList<UIComponent> resources = null;
        UIComponent firstFacet = uiComponent.getFacet(MIDDLE_FACET);
        if (firstFacet != null) {
            resources = new ArrayList<UIComponent>();
            resources.add(firstFacet);
        }
        return resources;
    }

    private boolean ableToAddResourceToHead(PortalContext portalContext, UIComponent componentResource) {
        if (this.isStyleSheetResource(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.style.sheet.resource.to.head.support") != null;
        }
        if (HeadRendererBridgeImpl.isScriptResource(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.script.resource.to.head.support") != null;
        }
        if (this.isInlineStyleSheet(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.style.sheet.text.to.head.support") != null;
        }
        if (this.isInlineScript(componentResource)) {
            return portalContext.getProperty("com.liferay.faces.bridge.add.script.text.to.head.support") != null;
        }
        return false;
    }

    private boolean isInlineScript(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String rendererType = componentResource.getRendererType();
        return resourceName == null && "javax.faces.resource.Script".equals(rendererType);
    }

    private boolean isInlineStyleSheet(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String rendererType = componentResource.getRendererType();
        return resourceName == null && "javax.faces.resource.Stylesheet".equals(rendererType);
    }

    private boolean isStyleSheetResource(UIComponent componentResource) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        return resourceName != null && resourceName.endsWith("css");
    }
}

