/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.ElementBlankImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.ElementWriter;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Stack;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementWriterStack
extends Stack<ElementWriter> {
    private static final long serialVersionUID = 3761771658484098988L;
    private static final Logger logger = LoggerFactory.getLogger(ElementWriterStack.class);

    @Override
    public synchronized ElementWriter pop() {
        ElementWriter topElementWriter = (ElementWriter)super.pop();
        Element topElement = topElementWriter.getElement();
        boolean done = this.isEmpty();
        while (!done) {
            Element peekedElement = ((ElementWriter)this.peek()).getElement();
            if (peekedElement instanceof ElementBlankImpl) {
                String topTextContent;
                StringBuilder prependedTextContent = new StringBuilder();
                String peekedTextContent = peekedElement.getTextContent();
                if (peekedTextContent != null) {
                    prependedTextContent.append(peekedTextContent);
                }
                if ((topTextContent = topElement.getTextContent()) != null) {
                    prependedTextContent.append(topTextContent);
                }
                topElement.setTextContent(prependedTextContent.toString());
                super.pop();
                done = this.isEmpty();
                continue;
            }
            done = true;
        }
        return topElementWriter;
    }

    public synchronized ElementWriter safePeek() {
        if (this.isEmpty()) {
            logger.debug("Stack was empty so created blank element", (Object[])null);
            this.push(new ElementWriter(new ElementBlankImpl()));
        }
        return (ElementWriter)this.peek();
    }
}

