/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriterWrapper;
import javax.portlet.PortalContext;
import javax.portlet.PortletRequest;

public abstract class ResponseWriterBridgeCompat_2_0_Impl
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeCompat_2_0_Impl.class);
    protected static final String ATTRIBUTE_AUTOCOMPLETE = "autocomplete";
    protected static final String DOCTYPE_MARKER = "<!DOCTYPE";
    protected static final String VALUE_OFF = "off";
    protected static final String VIEW_STATE_MARKER = "javax.faces.ViewState";
    protected static final String XML_MARKER = "<?xml";
    private static final boolean JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;
    protected boolean namespacedParameters;

    public ResponseWriterBridgeCompat_2_0_Impl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        String namespacedParametersSupport = portalContext.getProperty("com.liferay.faces.bridge.strict.namespaced.paramters.support");
        this.namespacedParameters = namespacedParametersSupport != null && JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            String data = new String(cbuf, off, len);
            if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                logger.trace("filtering marker");
                int greaterThanPos = data.indexOf(">");
                if (greaterThanPos > 0) {
                    len -= greaterThanPos + 1;
                    off += greaterThanPos + 1;
                }
            }
            if (len > 0) {
                if (logger.isTraceEnabled()) {
                    String value = new String(cbuf, off, len);
                    logger.trace("writing value=[{0}]", new Object[]{value});
                }
                this.getWrapped().write(cbuf, off, len);
            }
        }
    }

    protected void writeViewStateHiddenField() throws IOException {
        FacesContext facesContext;
        this.startElement("input", null);
        this.writeAttribute("type", "hidden", null);
        String viewStateName = VIEW_STATE_MARKER;
        if (this.namespacedParameters) {
            facesContext = FacesContext.getCurrentInstance();
            String namingContainerId = facesContext.getViewRoot().getContainerClientId(facesContext);
            viewStateName = namingContainerId + viewStateName;
        }
        this.writeAttribute("name", viewStateName, null);
        this.writeAttribute("id", viewStateName, null);
        facesContext = FacesContext.getCurrentInstance();
        String viewState = facesContext.getApplication().getStateManager().getViewState(facesContext);
        this.writeAttribute("value", viewState, null);
        this.writeAttribute(ATTRIBUTE_AUTOCOMPLETE, VALUE_OFF, null);
        this.endElement("input");
    }

    static {
        boolean namespacedViewStateSupported = false;
        Product mojarra = ProductFactory.getProduct((Product.Name)Product.Name.MOJARRA);
        if (mojarra.isDetected()) {
            int mojarraMajorVersion = mojarra.getMajorVersion();
            if (mojarraMajorVersion == 2) {
                int mojarraMinorVersion = mojarra.getMinorVersion();
                if (mojarraMinorVersion == 1) {
                    namespacedViewStateSupported = mojarra.getPatchVersion() >= 27;
                } else if (mojarraMinorVersion == 2) {
                    namespacedViewStateSupported = mojarra.getPatchVersion() >= 4;
                } else if (mojarraMinorVersion > 2) {
                    namespacedViewStateSupported = true;
                }
            } else if (mojarraMajorVersion > 2) {
                namespacedViewStateSupported = true;
            }
        }
        Product jsf = ProductFactory.getProduct((Product.Name)Product.Name.JSF);
        logger.debug("JSF runtime [{0}] version [{1}].[{2}].[{3}] supports namespacing [{4}]: [{5}]", new Object[]{jsf.getTitle(), jsf.getMajorVersion(), jsf.getMinorVersion(), jsf.getPatchVersion(), VIEW_STATE_MARKER, namespacedViewStateSupported});
        JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE = namespacedViewStateSupported;
    }
}

