/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.PortletConfigParamUtil;
import com.liferay.faces.util.config.ConfigParam;
import com.liferay.faces.util.helper.BooleanHelper;
import javax.portlet.PortletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PortletConfigParam implements ConfigParam<PortletConfig>
{
    BridgeRequestScopeAjaxEnabled("com.liferay.faces.bridge.bridgeRequestScopeAjaxEnabled", false),
    BridgeRequestScopePreserved("com.liferay.faces.bridge.bridgeRequestScopePreserved", "org.portletfaces.bridgeRequestScopePreserved", false),
    ContainerAbleToSetHttpStatusCode("com.liferay.faces.bridge.containerAbleToSetHttpStatusCode", "org.portletfaces.bridge.containerAbleToSetHttpStatusCode", false),
    ManageIncongruities("com.liferay.faces.bridge.manageIncongruities", true),
    PreferPreDestroy("com.liferay.faces.bridge.preferPreDestroy", "org.portletfaces.bridge.preferPreDestroy", true),
    PreserveActionParams("javax.portlet.faces.preserveActionParams", false),
    RenderRedirectEnabled("com.liferay.faces.bridge.renderRedirectEnabled", false),
    ResourceBufferSize("com.liferay.faces.bridge.resourceBufferSize", "org.portletfaces.bridge.resourceBufferSize", 1024),
    UploadedFilesDir("com.liferay.faces.bridge.uploadedFilesDir", "javax.faces.UPLOADED_FILES_DIR", System.getProperty("java.io.tmpdir")),
    UploadedFileMaxSize("com.liferay.faces.bridge.uploadedFileMaxSize", "javax.faces.UPLOADED_FILE_MAX_SIZE", 0x6400000L),
    ViewIdRenderParameterName("com.liferay.faces.bridge.viewIdRenderParameterName", "_facesViewIdRender"),
    ViewIdResourceParameterName("com.liferay.faces.bridge.viewIdResourceParameterName", "_facesViewIdResource"),
    ViewParametersEnabled("com.liferay.faces.bridge.viewParametersEnabled", true);

    private String alternateName;
    private boolean defaultBooleanValue;
    private String defaultStringValue;
    private int defaultIntegerValue;
    private long defaultLongValue;
    private String name;

    private PortletConfigParam(String name, String defaultStringValue) {
        this(name, null, defaultStringValue);
    }

    private PortletConfigParam(String name, boolean defaultBooleanValue) {
        this(name, null, defaultBooleanValue);
    }

    private PortletConfigParam(String name, String alternateName, int defaultIntegerValue) {
        this.name = name;
        this.alternateName = alternateName;
        this.defaultBooleanValue = defaultIntegerValue != 0;
        this.defaultIntegerValue = defaultIntegerValue;
        this.defaultLongValue = defaultIntegerValue;
        this.defaultStringValue = Integer.toString(defaultIntegerValue);
    }

    private PortletConfigParam(String name, String alternateName, long defaultLongValue) {
        this.name = name;
        this.alternateName = alternateName;
        boolean bl = this.defaultBooleanValue = defaultLongValue != 0L;
        this.defaultIntegerValue = defaultLongValue < Integer.MIN_VALUE ? Integer.MIN_VALUE : (defaultLongValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)defaultLongValue);
        this.defaultLongValue = defaultLongValue;
        this.defaultStringValue = Long.toString(defaultLongValue);
    }

    private PortletConfigParam(String name, String alternateName, String defaultStringValue) {
        this.name = name;
        this.alternateName = alternateName;
        if (BooleanHelper.isTrueToken((String)defaultStringValue)) {
            this.defaultBooleanValue = true;
            this.defaultIntegerValue = 1;
            this.defaultLongValue = 1L;
        } else {
            this.defaultBooleanValue = false;
            this.defaultIntegerValue = 0;
            this.defaultLongValue = 0L;
        }
        this.defaultStringValue = defaultStringValue;
    }

    private PortletConfigParam(String name, String alternateName, boolean defaultBooleanValue) {
        this.name = name;
        this.alternateName = alternateName;
        this.defaultBooleanValue = defaultBooleanValue;
        if (defaultBooleanValue) {
            this.defaultIntegerValue = 1;
            this.defaultLongValue = 1L;
            this.defaultStringValue = Boolean.TRUE.toString();
        } else {
            this.defaultIntegerValue = 0;
            this.defaultLongValue = 0L;
            this.defaultStringValue = Boolean.FALSE.toString();
        }
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public boolean getBooleanValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getBooleanValue(portletConfig, this.name, this.alternateName, this.defaultBooleanValue);
    }

    public String getConfiguredValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getConfiguredValue(portletConfig, this.name, this.alternateName);
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultBooleanValue;
    }

    public int getDefaultIntegerValue() {
        return this.defaultIntegerValue;
    }

    public long getDefaultLongValue() {
        return this.defaultLongValue;
    }

    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    public int getIntegerValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getIntegerValue(portletConfig, this.name, this.alternateName, this.defaultIntegerValue);
    }

    public long getLongValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getLongValue(portletConfig, this.name, this.alternateName, this.defaultLongValue);
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getStringValue(portletConfig, this.name, this.alternateName, this.defaultStringValue);
    }

    public boolean isConfigured(PortletConfig portletConfig) {
        return PortletConfigParamUtil.isSpecified(portletConfig, this.name, this.alternateName);
    }
}

