/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BaseURLNonEncodedDirectImpl;
import com.liferay.faces.bridge.internal.BaseURLNonEncodedImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.bridge.internal.PortletURLHelper;
import com.liferay.faces.util.helper.BooleanHelper;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class BridgeURLActionImpl
extends BridgeURLBase {
    private boolean directLink;
    private boolean bookmarkable;
    private boolean redirect;

    public BridgeURLActionImpl(String uri, String contextPath, String namespace, String currentViewId, BridgeConfig bridgeConfig) throws URISyntaxException {
        super(uri, contextPath, namespace, currentViewId, bridgeConfig);
        if (this.bridgeURI.isPortletScheme()) {
            String facesViewPathParameter;
            String facesViewIdParameter = this.bridgeURI.getParameter("_jsfBridgeViewId");
            if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                this.selfReferencing = true;
                this.bridgeURI.removeParameter("_jsfBridgeViewId");
            }
            if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = this.bridgeURI.getParameter("_jsfBridgeViewPath"))) {
                this.selfReferencing = true;
                this.bridgeURI.removeParameter("_jsfBridgeViewPath");
            }
        } else {
            String redirectParam;
            String bookmarkableParam;
            String directLinkParam = this.bridgeURI.getParameter("javax.portlet.faces.DirectLink");
            if (directLinkParam != null) {
                if (BooleanHelper.isTrueToken((String)directLinkParam)) {
                    this.directLink = true;
                } else {
                    this.bridgeURI.removeParameter("javax.portlet.faces.DirectLink");
                }
            }
            if (BooleanHelper.isTrueToken((String)(bookmarkableParam = this.bridgeURI.getParameter("_jsfBridgeBookmarkable")))) {
                this.bookmarkable = true;
                this.bridgeURI.removeParameter("_jsfBridgeBookmarkable");
            }
            if (BooleanHelper.isTrueToken((String)(redirectParam = this.bridgeURI.getParameter("_jsfBridgeRedirect")))) {
                this.redirect = true;
                this.bridgeURI.removeParameter("_jsfBridgeRedirect");
            }
        }
    }

    public BaseURL toBaseURL() throws MalformedURLException {
        Object baseURL;
        String uri = this.bridgeURI.toString();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE) {
            baseURL = new BaseURLNonEncodedImpl(this.bridgeURI);
        } else if (uri.startsWith("#") || this.bridgeURI.isAbsolute() && this.bridgeURI.isExternal(this.contextPath)) {
            baseURL = new BaseURLNonEncodedImpl(this.bridgeURI);
        } else if (this.directLink || this.bridgeURI.isExternal(this.contextPath)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            baseURL = new BaseURLNonEncodedDirectImpl(this.bridgeURI, portletRequest.getScheme(), portletRequest.getServerName(), portletRequest.getServerPort());
        } else {
            Bridge.PortletPhase urlPortletPhase;
            boolean modeChanged = false;
            String portletMode = this.getParameter("javax.portlet.faces.PortletMode");
            if (portletMode != null && portletMode.length() > 0) {
                modeChanged = true;
            }
            baseURL = this.bridgeURI.isPortletScheme() ? ((urlPortletPhase = this.bridgeURI.getPortletPhase()) == Bridge.PortletPhase.ACTION_PHASE ? this.createActionURL(facesContext, modeChanged) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.createRenderURL(facesContext, modeChanged) : this.createResourceURL(facesContext, modeChanged))) : (portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE ? new BaseURLNonEncodedImpl(this.bridgeURI) : (this.bookmarkable || this.redirect && portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE ? this.createRenderURL(facesContext, modeChanged) : this.createActionURL(facesContext, modeChanged)));
            if (this.selfReferencing) {
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                this.copyRenderParameters(portletRequest, (BaseURL)baseURL);
            }
            if (baseURL instanceof PortletURL) {
                PortletURL portletURL = (PortletURL)baseURL;
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                PortletURLHelper.setPortletMode(portletURL, portletMode, portletRequest);
                portletURL.setParameter("javax.portlet.faces.PortletMode", (String)null);
                String windowState = this.getParameter("javax.portlet.faces.WindowState");
                PortletURLHelper.setWindowState(portletURL, windowState, portletRequest);
                portletURL.setParameter("javax.portlet.faces.WindowState", (String)null);
            }
            String secure = this.getParameter("javax.portlet.faces.Secure");
            PortletURLHelper.setSecure((BaseURL)baseURL, secure);
            baseURL.setParameter("javax.portlet.faces.Secure", (String)null);
        }
        return baseURL;
    }
}

