/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BridgeConfigAttributeMap;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredElement;
import com.liferay.faces.util.config.FacesConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeConfigImpl
implements BridgeConfig {
    private static final String EXCLUDED_ATTRIBUTE = "excluded-attribute";
    private static final String MODEL_EL = "model-el";
    private static final String PARAMETER = "parameter";
    private static final String RENDER_RESPONSE_WRAPPER_CLASS = "render-response-wrapper-class";
    private static final String RESOURCE_RESPONSE_WRAPPER_CLASS = "resource-response-wrapper-class";
    private final Map<String, Object> bridgeConfigAttributeMap;
    private final Set<String> excludedRequestAttributes;
    private final Map<String, String[]> publicParameterMappings;
    private final String viewIdRenderParameterName;
    private final String viewIdResourceParameterName;

    public BridgeConfigImpl(PortletConfig portletConfig) {
        BridgeConfigAttributeMap bridgeConfigAttributeMap = new BridgeConfigAttributeMap();
        String appConfigAttrName = ApplicationConfig.class.getName();
        PortletContext portletContext = portletConfig.getPortletContext();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        FacesConfig facesConfig = applicationConfig.getFacesConfig();
        bridgeConfigAttributeMap.put("configuredFacesServletMappings", facesConfig.getConfiguredFacesServletMappings());
        bridgeConfigAttributeMap.put("configuredSystemEventListeners", facesConfig.getConfiguredSystemEventListeners());
        bridgeConfigAttributeMap.put("configuredSuffixes", facesConfig.getConfiguredSuffixes());
        this.bridgeConfigAttributeMap = Collections.unmodifiableMap(bridgeConfigAttributeMap);
        HashSet<String> excludedRequestAttributes = new HashSet<String>();
        List configuredApplicationExtensions = facesConfig.getConfiguredApplicationExtensions();
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            String configuredElementName = configuredElement.getName();
            if (!EXCLUDED_ATTRIBUTE.equals(configuredElementName)) continue;
            String excludedAttributeName = configuredElement.getValue();
            excludedRequestAttributes.add(excludedAttributeName);
        }
        this.excludedRequestAttributes = Collections.unmodifiableSet(excludedRequestAttributes);
        HashMap<String, String[]> publicParameterMappings = new HashMap<String, String[]>();
        String parameter = null;
        String modelEL = null;
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            String configuredElementName = configuredElement.getName();
            if (PARAMETER.equals(configuredElementName)) {
                parameter = configuredElement.getValue();
                continue;
            }
            if (!MODEL_EL.equals(configuredElementName)) continue;
            modelEL = configuredElement.getValue();
            if (parameter == null || modelEL == null || modelEL.length() <= 0) continue;
            String[] newValue = new String[]{modelEL};
            String[] existingValue = (String[])publicParameterMappings.get(parameter);
            if (existingValue != null) {
                int total = existingValue.length + 1;
                newValue = new String[total];
                for (int i = 0; i < existingValue.length; ++i) {
                    newValue[i] = existingValue[i];
                }
                newValue[total - 1] = modelEL;
            }
            publicParameterMappings.put(parameter, newValue);
        }
        this.publicParameterMappings = Collections.unmodifiableMap(publicParameterMappings);
        this.viewIdResourceParameterName = PortletConfigParam.ViewIdResourceParameterName.getStringValue(portletConfig);
        this.viewIdRenderParameterName = PortletConfigParam.ViewIdRenderParameterName.getStringValue(portletConfig);
    }

    public Map<String, Object> getAttributes() {
        return this.bridgeConfigAttributeMap;
    }

    public Set<String> getExcludedRequestAttributes() {
        return this.excludedRequestAttributes;
    }

    public Map<String, String[]> getPublicParameterMappings() {
        return this.publicParameterMappings;
    }

    public String getViewIdRenderParameterName() {
        return this.viewIdRenderParameterName;
    }

    public String getViewIdResourceParameterName() {
        return this.viewIdResourceParameterName;
    }
}

