/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.map.internal.RequestHeaderValuesMapCompat;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Locale;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;

public class RequestHeaderValuesMap
extends RequestHeaderValuesMapCompat {
    private static final String CHARSET = "charset";
    private static final String PARTIAL_AJAX = "partial/ajax";
    private static final long serialVersionUID = 4910578014366086738L;
    private static final Logger logger = LoggerFactory.getLogger(RequestHeaderValuesMap.class);
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_FACES_REQUEST = "Faces-Request";

    public RequestHeaderValuesMap(PortletRequest portletRequest) {
        FacesContext facesContext;
        ExternalContext externalContext;
        String facesAjaxParam;
        Enumeration propertyNames = portletRequest.getPropertyNames();
        boolean foundAccept = false;
        boolean foundContentType = false;
        boolean foundFacesRequest = false;
        if (propertyNames != null) {
            while (propertyNames.hasMoreElements()) {
                int i;
                StringBuilder buf;
                Enumeration locales;
                boolean addHeader = true;
                String name = (String)propertyNames.nextElement();
                if (name.equalsIgnoreCase(HEADER_ACCEPT_LANGUAGE) && (locales = portletRequest.getLocales()) != null) {
                    addHeader = false;
                    buf = new StringBuilder();
                    i = 0;
                    while (locales.hasMoreElements()) {
                        if (i > 0) {
                            buf.append(",");
                        }
                        Locale locale = (Locale)locales.nextElement();
                        buf.append(locale.getLanguage());
                        String country = locale.getCountry();
                        if (country != null && country.length() > 0) {
                            buf.append("-");
                            buf.append(country);
                        }
                        ++i;
                    }
                    super.put(name, new String[]{buf.toString()});
                }
                if (!addHeader) continue;
                Enumeration properties = portletRequest.getProperties(name);
                buf = new StringBuilder();
                if (properties != null) {
                    i = 0;
                    while (properties.hasMoreElements()) {
                        if (i > 0) {
                            buf.append(",");
                        }
                        buf.append((String)properties.nextElement());
                        ++i;
                    }
                }
                String values = buf.toString();
                super.put(name, new String[]{values});
                if (values.length() <= 0) continue;
                if (!foundAccept) {
                    foundAccept = name.equalsIgnoreCase(HEADER_ACCEPT);
                }
                if (!foundContentType) {
                    foundContentType = name.equalsIgnoreCase(HEADER_CONTENT_TYPE);
                }
                if (foundFacesRequest) continue;
                foundFacesRequest = name.equalsIgnoreCase(HEADER_FACES_REQUEST);
            }
        }
        if (!foundAccept) {
            this.addAcceptHeader(portletRequest);
        }
        if (!foundContentType) {
            this.addContentTypeHeader(portletRequest);
        }
        if (!foundFacesRequest && portletRequest instanceof ResourceRequest && (facesAjaxParam = (String)(externalContext = (facesContext = FacesContext.getCurrentInstance()).getExternalContext()).getRequestParameterMap().get("_jsfBridgeAjax")) != null && BooleanHelper.isTrueToken((String)facesAjaxParam)) {
            this.put(HEADER_FACES_REQUEST, new String[]{PARTIAL_AJAX});
        }
        this.addJSF1Headers(portletRequest);
    }

    protected void addAcceptHeader(PortletRequest portletRequest) {
        StringBuilder header = new StringBuilder();
        Enumeration responseContentTypes = portletRequest.getResponseContentTypes();
        boolean firstElement = true;
        while (responseContentTypes.hasMoreElements()) {
            if (!firstElement) {
                header.append(",");
            }
            String responseContentType = (String)responseContentTypes.nextElement();
            header.append(responseContentType);
            firstElement = false;
        }
        String acceptHeader = header.toString();
        logger.debug("Adding acceptHeader=[{0}] to header map", new Object[]{acceptHeader});
        this.put(HEADER_ACCEPT, new String[]{header.toString()});
    }

    protected void addContentTypeHeader(PortletRequest portletRequest) {
        if (portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)portletRequest;
            String contentType = clientDataRequest.getContentType();
            String characterSetEncoding = clientDataRequest.getCharacterEncoding();
            StringBuilder header = new StringBuilder();
            header.append(HEADER_CONTENT_TYPE);
            header.append(": ");
            header.append(contentType);
            if (characterSetEncoding != null) {
                header.append("; ");
                header.append(CHARSET);
                header.append("=");
                header.append(characterSetEncoding);
            }
            String contentTypeHeader = header.toString();
            logger.debug("Adding contentTypeHeader=[{0}] to header map", new Object[]{contentTypeHeader});
            this.put(HEADER_CONTENT_TYPE, new String[]{header.toString()});
        }
    }
}

