/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataProcessor;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFileFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartFormDataProcessorImpl
implements MultiPartFormDataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartFormDataProcessorImpl.class);

    @Override
    public Map<String, List<UploadedFile>> process(ClientDataRequest clientDataRequest, PortletConfig portletConfig, FacesRequestParameterMap facesRequestParameterMap) {
        HashMap<String, List<UploadedFile>> uploadedFileMap;
        block18: {
            PortletSession portletSession = clientDataRequest.getPortletSession();
            String uploadedFilesDir = PortletConfigParam.UploadedFilesDir.getStringValue(portletConfig);
            String sessionId = portletSession.getId();
            File uploadedFilesPath = new File(uploadedFilesDir, sessionId = sessionId.replaceAll("[^A-Za-z0-9]", ""));
            if (!uploadedFilesPath.exists() && !uploadedFilesPath.mkdirs()) {
                logger.warn("Unable to create directory for uploadedFilesPath=[{0}]", new Object[]{uploadedFilesPath});
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            diskFileItemFactory.setRepository(uploadedFilesPath);
            diskFileItemFactory.setFileCleaningTracker(null);
            diskFileItemFactory.setSizeThreshold(0);
            long uploadedFileMaxSize = PortletConfigParam.UploadedFileMaxSize.getLongValue(portletConfig);
            PortletFileUpload portletFileUpload = new PortletFileUpload((FileItemFactory)diskFileItemFactory);
            portletFileUpload.setFileSizeMax(uploadedFileMaxSize);
            uploadedFileMap = new HashMap<String, List<UploadedFile>>();
            Set actionRequestParameterSet = clientDataRequest.getParameterMap().entrySet();
            for (Map.Entry mapEntry : actionRequestParameterSet) {
                String parameterName = (String)mapEntry.getKey();
                String[] parameterValues = (String[])mapEntry.getValue();
                if (parameterValues.length <= 0) continue;
                for (String parameterValue : parameterValues) {
                    facesRequestParameterMap.addValue(parameterName, parameterValue);
                }
            }
            UploadedFileFactory uploadedFileFactory = (UploadedFileFactory)BridgeFactoryFinder.getFactory(UploadedFileFactory.class);
            try {
                FileItemIterator fileItemIterator;
                if (clientDataRequest instanceof ResourceRequest) {
                    ResourceRequest resourceRequest = (ResourceRequest)clientDataRequest;
                    fileItemIterator = portletFileUpload.getItemIterator((ActionRequest)new ActionRequestAdapter(resourceRequest));
                } else {
                    ActionRequest actionRequest = (ActionRequest)clientDataRequest;
                    fileItemIterator = portletFileUpload.getItemIterator(actionRequest);
                }
                if (fileItemIterator == null) break block18;
                int totalFiles = 0;
                while (fileItemIterator.hasNext()) {
                    try {
                        String fileName;
                        ++totalFiles;
                        FileItemStream fieldStream = fileItemIterator.next();
                        String fieldName = fieldStream.getFieldName();
                        String contentType = fieldStream.getContentType();
                        boolean formField = fieldStream.isFormField();
                        try {
                            fileName = fieldStream.getName();
                        }
                        catch (InvalidFileNameException e) {
                            fileName = e.getName();
                        }
                        DiskFileItem diskFileItem = (DiskFileItem)diskFileItemFactory.createItem(fieldName, contentType, formField, fileName);
                        Streams.copy((InputStream)fieldStream.openStream(), (OutputStream)diskFileItem.getOutputStream(), (boolean)true);
                        if (diskFileItem.isFormField()) {
                            String characterEncoding = clientDataRequest.getCharacterEncoding();
                            String requestParameterValue = characterEncoding == null ? diskFileItem.getString() : diskFileItem.getString(characterEncoding);
                            facesRequestParameterMap.addValue(fieldName, requestParameterValue);
                            continue;
                        }
                        File tempFile = diskFileItem.getStoreLocation();
                        if (tempFile.exists()) {
                            Iterator headerNameItr;
                            String tempFileName = tempFile.getName();
                            String tempFileAbsolutePath = tempFile.getAbsolutePath();
                            String copiedFileName = this.stripIllegalCharacters(fileName);
                            String copiedFileAbsolutePath = tempFileAbsolutePath.replace(tempFileName, copiedFileName);
                            File copiedFile = new File(copiedFileAbsolutePath);
                            FileUtils.copyFile((File)tempFile, (File)copiedFile);
                            TreeMap headersMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                            FileItemHeaders fileItemHeaders = fieldStream.getHeaders();
                            if (fileItemHeaders != null && (headerNameItr = fileItemHeaders.getHeaderNames()) != null) {
                                while (headerNameItr.hasNext()) {
                                    String headerName = (String)headerNameItr.next();
                                    Iterator headerValuesItr = fileItemHeaders.getHeaders(headerName);
                                    ArrayList<String> headerValues = new ArrayList<String>();
                                    if (headerValuesItr != null) {
                                        while (headerValuesItr.hasNext()) {
                                            String headerValue = (String)headerValuesItr.next();
                                            headerValues.add(headerValue);
                                        }
                                    }
                                    headersMap.put(headerName, headerValues);
                                }
                            }
                            HashMap attributeMap = new HashMap();
                            String id = Long.toString((long)this.hashCode() + System.currentTimeMillis());
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(copiedFileAbsolutePath, attributeMap, diskFileItem.getCharSet(), diskFileItem.getContentType(), headersMap, id, null, fileName, diskFileItem.getSize(), UploadedFile.Status.FILE_SAVED);
                            facesRequestParameterMap.addValue(fieldName, copiedFileAbsolutePath);
                            this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                            logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", new Object[]{fieldName, fileName});
                            continue;
                        }
                        if (fileName == null || fileName.trim().length() <= 0) continue;
                        IOException e = new IOException("Failed to copy the stream of uploaded file=[" + fileName + "] to a temporary file (possibly a zero-length uploaded file)");
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile((Exception)e);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                        String fieldName = Integer.toString(totalFiles);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                this.addUploadedFile(uploadedFileMap, "unknown", uploadedFile);
            }
        }
        return uploadedFileMap;
    }

    protected void addUploadedFile(Map<String, List<UploadedFile>> uploadedFileMap, String fieldName, UploadedFile uploadedFile) {
        List<UploadedFile> uploadedFiles = uploadedFileMap.get(fieldName);
        if (uploadedFiles == null) {
            uploadedFiles = new ArrayList<UploadedFile>();
            uploadedFileMap.put(fieldName, uploadedFiles);
        }
        uploadedFiles.add(uploadedFile);
    }

    protected String stripIllegalCharacters(String fileName) {
        String strippedFileName = fileName;
        if (fileName != null) {
            int pos = fileName.lastIndexOf(".");
            strippedFileName = fileName.replaceAll("[\\\\/\\[\\]:|<>+;=.?\"]", "-");
            if (pos > 0) {
                strippedFileName = strippedFileName.substring(0, pos) + "." + strippedFileName.substring(pos + 1);
            }
        }
        return strippedFileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionRequestAdapter
    implements ActionRequest {
        private ResourceRequest resourceRequest;

        public ActionRequestAdapter(ResourceRequest resourceRequest) {
            this.resourceRequest = resourceRequest;
        }

        public Object getAttribute(String name) {
            return this.resourceRequest.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.resourceRequest.getAttributeNames();
        }

        public String getAuthType() {
            return this.resourceRequest.getAuthType();
        }

        public String getCharacterEncoding() {
            return this.resourceRequest.getCharacterEncoding();
        }

        public int getContentLength() {
            return this.resourceRequest.getContentLength();
        }

        public String getContentType() {
            return this.resourceRequest.getContentType();
        }

        public String getContextPath() {
            return this.resourceRequest.getContextPath();
        }

        public Cookie[] getCookies() {
            return this.resourceRequest.getCookies();
        }

        public Locale getLocale() {
            return this.resourceRequest.getLocale();
        }

        public Enumeration<Locale> getLocales() {
            return this.resourceRequest.getLocales();
        }

        public String getMethod() {
            return this.resourceRequest.getMethod();
        }

        public String getParameter(String name) {
            return this.resourceRequest.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.resourceRequest.getParameterMap();
        }

        public Enumeration<String> getParameterNames() {
            return this.resourceRequest.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.resourceRequest.getParameterValues(name);
        }

        public PortalContext getPortalContext() {
            return this.resourceRequest.getPortalContext();
        }

        public InputStream getPortletInputStream() throws IOException {
            return this.resourceRequest.getPortletInputStream();
        }

        public PortletMode getPortletMode() {
            return this.resourceRequest.getPortletMode();
        }

        public PortletSession getPortletSession() {
            return this.resourceRequest.getPortletSession();
        }

        public PortletSession getPortletSession(boolean create) {
            return this.resourceRequest.getPortletSession();
        }

        public PortletPreferences getPreferences() {
            return this.resourceRequest.getPreferences();
        }

        public Map<String, String[]> getPrivateParameterMap() {
            return this.resourceRequest.getPrivateParameterMap();
        }

        public Enumeration<String> getProperties(String name) {
            return this.resourceRequest.getProperties(name);
        }

        public String getProperty(String name) {
            return this.resourceRequest.getProperty(name);
        }

        public Enumeration<String> getPropertyNames() {
            return this.resourceRequest.getPropertyNames();
        }

        public Map<String, String[]> getPublicParameterMap() {
            return this.resourceRequest.getPublicParameterMap();
        }

        public BufferedReader getReader() throws IOException {
            return this.resourceRequest.getReader();
        }

        public String getRemoteUser() {
            return this.resourceRequest.getRemoteUser();
        }

        public String getRequestedSessionId() {
            return this.resourceRequest.getRequestedSessionId();
        }

        public String getResponseContentType() {
            return this.resourceRequest.getResponseContentType();
        }

        public Enumeration<String> getResponseContentTypes() {
            return this.resourceRequest.getResponseContentTypes();
        }

        public String getScheme() {
            return this.resourceRequest.getScheme();
        }

        public String getServerName() {
            return this.resourceRequest.getServerName();
        }

        public int getServerPort() {
            return this.resourceRequest.getServerPort();
        }

        public Principal getUserPrincipal() {
            return this.resourceRequest.getUserPrincipal();
        }

        public String getWindowID() {
            return this.resourceRequest.getWindowID();
        }

        public WindowState getWindowState() {
            return this.resourceRequest.getWindowState();
        }

        public boolean isPortletModeAllowed(PortletMode mode) {
            return this.resourceRequest.isPortletModeAllowed(mode);
        }

        public boolean isRequestedSessionIdValid() {
            return this.resourceRequest.isRequestedSessionIdValid();
        }

        public boolean isSecure() {
            return this.resourceRequest.isSecure();
        }

        public boolean isUserInRole(String role) {
            return this.resourceRequest.isUserInRole(role);
        }

        public boolean isWindowStateAllowed(WindowState state) {
            return this.resourceRequest.isWindowStateAllowed(state);
        }

        public void removeAttribute(String name) {
            this.resourceRequest.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.resourceRequest.setAttribute(name, value);
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.resourceRequest.setCharacterEncoding(enc);
        }
    }
}

