/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesRequestParameterMapImpl
implements FacesRequestParameterMap {
    private static final Logger logger = LoggerFactory.getLogger(FacesRequestParameterMapImpl.class);
    private static final String COM_LIFERAY_FACES_BRIDGE = "com.liferay.faces.bridge";
    private static final String JAVAX_FACES = "javax.faces";
    private static final String PRIMEFACES_DYNAMIC_CONTENT_PARAM = "pfdrid";
    private BridgeRequestScope bridgeRequestScope;
    private String defaultRenderKitId;
    private Map<String, String> facesViewParameterMap;
    private String namespace;
    private Map<String, String[]> wrappedParameterMap;

    public FacesRequestParameterMapImpl(String namespace, BridgeRequestScope bridgeRequestScope, Map<String, String> facesViewParameterMap, String defaultRenderKitId) {
        this(new HashMap<String, String[]>(), namespace, bridgeRequestScope, facesViewParameterMap, defaultRenderKitId);
    }

    public FacesRequestParameterMapImpl(Map<String, String[]> parameterMap, String namespace, BridgeRequestScope bridgeRequestScope, Map<String, String> facesViewParameterMap, String defaultRenderKitId) {
        this.wrappedParameterMap = parameterMap;
        this.namespace = namespace;
        this.bridgeRequestScope = bridgeRequestScope;
        this.facesViewParameterMap = facesViewParameterMap;
        this.defaultRenderKitId = defaultRenderKitId;
    }

    public void addValue(String key, String value) {
        boolean namespacedKey = key != null && key.startsWith(this.namespace);
        String[] values = this.get(key);
        if (values == null) {
            values = new String[]{value};
        } else {
            values = Arrays.copyOf(values, values.length + 1);
            values[values.length - 1] = value;
        }
        if (namespacedKey) {
            this.wrappedParameterMap.put(key, values);
        } else {
            this.wrappedParameterMap.put(this.namespace + key, values);
        }
    }

    public void clear() {
        this.wrappedParameterMap.clear();
    }

    public boolean containsKey(Object key) {
        boolean found;
        block5: {
            String keyAsString;
            block6: {
                block7: {
                    String[] values;
                    found = false;
                    if (key == null) break block5;
                    found = this.wrappedParameterMap.containsKey(key);
                    if (!found) {
                        found = this.wrappedParameterMap.containsKey(this.namespace + key);
                    }
                    if (!found && (values = this.wrappedParameterMap.get(key.toString())) != null) {
                        for (String value : values) {
                            if (value == null || value.length() <= 0) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) break block5;
                    keyAsString = (String)key;
                    if (!"javax.faces.ViewState".equals(keyAsString)) break block6;
                    String viewStateParam = this.getFirst(key);
                    if (viewStateParam != null) break block7;
                    if (this.bridgeRequestScope == null || (viewStateParam = this.bridgeRequestScope.getPreservedViewStateParam()) == null) break block5;
                    found = true;
                    break block5;
                }
                found = true;
                break block5;
            }
            if (!keyAsString.startsWith(JAVAX_FACES)) {
                String parameterName;
                Set<String> parameterNames = this.keySet();
                Iterator<String> i$ = parameterNames.iterator();
                while (i$.hasNext() && !(found = (parameterName = i$.next()).equals(keyAsString))) {
                }
            }
        }
        return found;
    }

    public boolean containsValue(Object value) {
        return this.wrappedParameterMap.containsValue(value);
    }

    public Set<Map.Entry<String, String[]>> entrySet() {
        return this.wrappedParameterMap.entrySet();
    }

    public String[] get(Object key) {
        String specialParameterValue;
        String[] values = this.wrappedParameterMap.get(key);
        if (values == null) {
            values = this.wrappedParameterMap.get(this.namespace + key);
        }
        if (values == null && (specialParameterValue = this.getSpecialParameterValue(key.toString())) != null) {
            values = new String[]{specialParameterValue};
        }
        return values;
    }

    public String getFirst(Object key) {
        String firstValue = null;
        if (key != null) {
            String[] values = this.get(key);
            if (values == null) {
                values = this.get(this.namespace + key);
            }
            if (values != null && values.length > 0) {
                firstValue = values[0];
            }
            if (firstValue == null) {
                firstValue = this.getSpecialParameterValue(key.toString());
            }
        }
        logger.trace("{0}=[{1}]", new Object[]{key, firstValue});
        return firstValue;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isEmpty() {
        return this.wrappedParameterMap.isEmpty();
    }

    public Set<String> keySet() {
        Map<String, String> preservedActionParamMap;
        String viewStateParam;
        HashSet<String> keyNames = new HashSet<String>();
        String renderKitIdParam = this.getFirst("javax.faces.RenderKitId");
        if (renderKitIdParam == null) {
            renderKitIdParam = this.defaultRenderKitId;
        }
        ArrayList<String> requestParamerNameList = new ArrayList<String>();
        requestParamerNameList.addAll(this.wrappedParameterMap.keySet());
        if (renderKitIdParam != null) {
            requestParamerNameList.add("javax.faces.RenderKitId");
        }
        if ((viewStateParam = this.getFirst("javax.faces.ViewState")) == null && this.bridgeRequestScope != null) {
            viewStateParam = this.bridgeRequestScope.getPreservedViewStateParam();
        }
        if (viewStateParam != null) {
            requestParamerNameList.add("javax.faces.ViewState");
        }
        if (this.bridgeRequestScope != null && (preservedActionParamMap = this.bridgeRequestScope.getPreservedActionParameterMap()) != null) {
            Set<String> keySet = preservedActionParamMap.keySet();
            for (String key : keySet) {
                requestParamerNameList.add(key);
            }
        }
        Set<String> keySet = this.facesViewParameterMap.keySet();
        for (String key : keySet) {
            requestParamerNameList.add(key);
        }
        keyNames.addAll(requestParamerNameList);
        return keyNames;
    }

    public String[] put(String key, String[] value) {
        return this.wrappedParameterMap.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends String[]> m) {
        this.wrappedParameterMap.putAll(m);
    }

    public String[] remove(Object key) {
        return this.wrappedParameterMap.remove(key);
    }

    public int size() {
        return this.wrappedParameterMap.size();
    }

    public Collection<String[]> values() {
        return this.wrappedParameterMap.values();
    }

    protected String getSpecialParameterValue(String parameterName) {
        String specialParameterValue = null;
        if ("javax.faces.RenderKitId".equals(parameterName)) {
            specialParameterValue = this.defaultRenderKitId;
        } else if ("javax.faces.ViewState".equals(parameterName)) {
            if (this.bridgeRequestScope != null) {
                specialParameterValue = this.bridgeRequestScope.getPreservedViewStateParam();
            }
        } else if (!(parameterName.startsWith(COM_LIFERAY_FACES_BRIDGE) || "_jsfBridgeAjax".equals(parameterName) || PRIMEFACES_DYNAMIC_CONTENT_PARAM.equals(parameterName) || this.bridgeRequestScope == null)) {
            Map<String, String> preservedActionParamMap = this.bridgeRequestScope.getPreservedActionParameterMap();
            if (preservedActionParamMap != null) {
                specialParameterValue = preservedActionParamMap.get(parameterName);
            }
            if (specialParameterValue == null) {
                specialParameterValue = this.facesViewParameterMap.get(parameterName);
            }
        }
        return specialParameterValue;
    }
}

