/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.map.internal.ApplicationScopeMap;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.context.map.internal.FacesRequestParameterMapImpl;
import com.liferay.faces.bridge.context.map.internal.FacesViewParameterMap;
import com.liferay.faces.bridge.context.map.internal.InitParameterMap;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataImpl;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataProcessorImpl;
import com.liferay.faces.bridge.context.map.internal.RequestCookieMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderValuesMap;
import com.liferay.faces.bridge.context.map.internal.RequestParameterMap;
import com.liferay.faces.bridge.context.map.internal.RequestParameterValuesMap;
import com.liferay.faces.bridge.context.map.internal.RequestScopeMap;
import com.liferay.faces.bridge.context.map.internal.ServletContextAttributeMap;
import com.liferay.faces.bridge.context.map.internal.SessionScopeMap;
import com.liferay.faces.bridge.model.internal.UploadedFileBridgeImpl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.context.map.MultiPartFormData;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMapFactoryImpl
extends ContextMapFactory {
    private static final boolean ICEFACES_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.ICEFACES).isDetected();
    private static final String MULTIPART_FORM_DATA_FQCN = MultiPartFormData.class.getName();

    @Override
    public Map<String, Object> getApplicationScopeMap(PortletContext portletContext, boolean preferPredestroy) {
        return new ApplicationScopeMap(portletContext, preferPredestroy);
    }

    @Override
    public Map<String, String> getFacesViewParameterMap(String facesViewQueryString) {
        return new FacesViewParameterMap(facesViewQueryString);
    }

    @Override
    public Map<String, String> getInitParameterMap(PortletContext portletContext) {
        return Collections.unmodifiableMap(new InitParameterMap(portletContext));
    }

    @Override
    public Map<String, Object> getRequestCookieMap(PortletRequest portletRequest) {
        return new RequestCookieMap(portletRequest.getCookies());
    }

    @Override
    public Map<String, String> getRequestHeaderMap(PortletRequest portletRequest) {
        return new RequestHeaderMap(this.getRequestHeaderValuesMap(portletRequest));
    }

    @Override
    public Map<String, String[]> getRequestHeaderValuesMap(PortletRequest portletRequest) {
        return new RequestHeaderValuesMap(portletRequest);
    }

    @Override
    public Map<String, String> getRequestParameterMap(PortletRequest portletRequest, String responseNamespace, PortletConfig portletConfig, BridgeRequestScope bridgeRequestScope, String defaultRenderKitId, String facesViewQueryString) {
        FacesRequestParameterMap facesRequestParameterMap = this.getFacesRequestParameterMap(portletRequest, responseNamespace, portletConfig, bridgeRequestScope, defaultRenderKitId, facesViewQueryString);
        return new RequestParameterMap(facesRequestParameterMap);
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap(PortletRequest portletRequest, String responseNamespace, PortletConfig portletConfig, BridgeRequestScope bridgeRequestScope, String defaultRenderKitId, String facesViewQueryString) {
        FacesRequestParameterMap facesRequestParameterMap = this.getFacesRequestParameterMap(portletRequest, responseNamespace, portletConfig, bridgeRequestScope, defaultRenderKitId, facesViewQueryString);
        return new RequestParameterValuesMap(facesRequestParameterMap);
    }

    @Override
    public Map<String, Object> getRequestScopeMap(PortletContext portletContext, PortletRequest portletRequest, String responseNamespace, Set<String> removedAttributeNames, boolean preferPreDestroy) {
        return new RequestScopeMap(portletContext, portletRequest, removedAttributeNames, preferPreDestroy);
    }

    @Override
    public Map<String, Object> getServletContextAttributeMap(ServletContext servletContext) {
        return new ServletContextAttributeMap(servletContext);
    }

    @Override
    public Map<String, Object> getSessionScopeMap(PortletContext portletContext, PortletSession portletSession, int scope, boolean preferPreDestroy) {
        return new SessionScopeMap(portletContext, portletSession, scope, preferPreDestroy);
    }

    @Override
    public Map<String, List<com.liferay.faces.bridge.model.UploadedFile>> getUploadedFileMap(PortletRequest portletRequest) {
        Map uploadedFileMap;
        HashMap bridgeUploadedFileMap = null;
        MultiPartFormData multiPartFormData = (MultiPartFormData)portletRequest.getAttribute(MULTIPART_FORM_DATA_FQCN);
        if (multiPartFormData != null && (uploadedFileMap = multiPartFormData.getUploadedFileMap()) != null) {
            bridgeUploadedFileMap = new HashMap(uploadedFileMap.size());
            Set entrySet = uploadedFileMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                List uploadedFileList = (List)mapEntry.getValue();
                if (uploadedFileList == null) continue;
                ArrayList<UploadedFileBridgeImpl> bridgeUploadedFileList = new ArrayList<UploadedFileBridgeImpl>(uploadedFileList.size());
                for (UploadedFile uploadedFile : uploadedFileList) {
                    bridgeUploadedFileList.add(new UploadedFileBridgeImpl(uploadedFile));
                }
                bridgeUploadedFileMap.put(mapEntry.getKey(), bridgeUploadedFileList);
            }
        }
        return bridgeUploadedFileMap;
    }

    public ContextMapFactoryImpl getWrapped() {
        return null;
    }

    protected FacesRequestParameterMap getFacesRequestParameterMap(PortletRequest portletRequest, String responseNamespace, PortletConfig portletConfig, BridgeRequestScope bridgeRequestScope, String defaultRenderKitId, String facesViewQueryString) {
        FacesRequestParameterMapImpl facesRequestParameterMap = null;
        Map<String, String> facesViewParameterMap = this.getFacesViewParameterMap(facesViewQueryString);
        if (portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)portletRequest;
            String contentType = clientDataRequest.getContentType();
            if (!ICEFACES_DETECTED && contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
                MultiPartFormData multiPartFormData = (MultiPartFormData)portletRequest.getAttribute(MULTIPART_FORM_DATA_FQCN);
                if (multiPartFormData == null) {
                    facesRequestParameterMap = new FacesRequestParameterMapImpl(responseNamespace, bridgeRequestScope, facesViewParameterMap, defaultRenderKitId);
                    MultiPartFormDataProcessorImpl multiPartFormDataProcessor = new MultiPartFormDataProcessorImpl();
                    Map<String, List<UploadedFile>> uploadedFileMap = multiPartFormDataProcessor.process(clientDataRequest, portletConfig, facesRequestParameterMap);
                    multiPartFormData = new MultiPartFormDataImpl(facesRequestParameterMap, uploadedFileMap);
                    portletRequest.setAttribute(MULTIPART_FORM_DATA_FQCN, (Object)multiPartFormData);
                } else {
                    facesRequestParameterMap = multiPartFormData.getFacesRequestParameterMap();
                }
            }
        }
        if (facesRequestParameterMap == null) {
            Map parameterMap = portletRequest.getParameterMap();
            facesRequestParameterMap = new FacesRequestParameterMapImpl(parameterMap, responseNamespace, bridgeRequestScope, facesViewParameterMap, defaultRenderKitId);
        }
        return facesRequestParameterMap;
    }
}

