/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.RenderRedirectWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class RenderRedirectWriterImpl
extends RenderRedirectWriter {
    private Writer wrappedWriter;
    private List<OutputOperation> outputOperationList;

    public RenderRedirectWriterImpl(Writer writer) {
        this.wrappedWriter = writer;
        this.outputOperationList = new ArrayList<OutputOperation>();
    }

    public void close() throws IOException {
        this.outputOperationList.add(new CloseOperation(this.wrappedWriter));
    }

    public void discard() {
        this.outputOperationList = new ArrayList<OutputOperation>();
    }

    public void flush() throws IOException {
        this.outputOperationList.add(new FlushOperation(this.wrappedWriter));
    }

    public Writer getWrapped() {
        return this.wrappedWriter;
    }

    public void render() throws IOException {
        for (OutputOperation outputOperation : this.outputOperationList) {
            outputOperation.invoke();
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf != null) {
            this.outputOperationList.add(new CbufWriteOperation(this.wrappedWriter, cbuf));
        }
    }

    public void write(int c) throws IOException {
        this.outputOperationList.add(new IntWriteOperation(this.wrappedWriter, c));
    }

    public void write(String str) throws IOException {
        if (str != null) {
            this.outputOperationList.add(new StrWriteOperation(this.wrappedWriter, str));
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            this.outputOperationList.add(new CBufOffLenOutputOperation(this.wrappedWriter, cbuf, off, len));
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            this.outputOperationList.add(new StrOffLenWriteOperation(this.wrappedWriter, str, off, len));
        }
    }

    private static class StrWriteOperation
    implements OutputOperation {
        private String str;
        private Writer writer;

        public StrWriteOperation(Writer writer, String str) {
            this.str = str;
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.write(this.str);
        }
    }

    private static class StrOffLenWriteOperation
    implements OutputOperation {
        private String str;
        private int off;
        private int len;
        private Writer writer;

        public StrOffLenWriteOperation(Writer writer, String str, int off, int len) {
            this.str = str;
            this.off = off;
            this.len = len;
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.write(this.str, this.off, this.len);
        }
    }

    private static class IntWriteOperation
    implements OutputOperation {
        private int c;
        private Writer writer;

        public IntWriteOperation(Writer writer, int c) {
            this.c = c;
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.write(this.c);
        }
    }

    private static class FlushOperation
    implements OutputOperation {
        private Writer writer;

        public FlushOperation(Writer writer) {
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.flush();
        }
    }

    private static class CloseOperation
    implements OutputOperation {
        private Writer writer;

        public CloseOperation(Writer writer) {
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.close();
        }
    }

    private static class CbufWriteOperation
    implements OutputOperation {
        private char[] cbuf;
        private Writer writer;

        public CbufWriteOperation(Writer writer, char[] cbuf) {
            this.cbuf = (char[])cbuf.clone();
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.write(this.cbuf);
        }
    }

    private static class CBufOffLenOutputOperation
    implements OutputOperation {
        private char[] cbuf;
        private int off;
        private int len;
        private Writer writer;

        public CBufOffLenOutputOperation(Writer writer, char[] cbuf, int off, int len) {
            this.cbuf = (char[])cbuf.clone();
            this.off = off;
            this.len = len;
            this.writer = writer;
        }

        public void invoke() throws IOException {
            this.writer.write(this.cbuf, this.off, this.len);
        }
    }

    protected static interface OutputOperation {
        public void invoke() throws IOException;
    }
}

