/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.ElementWriter;
import com.liferay.faces.bridge.renderkit.html_basic.internal.ElementWriterStack;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.EmptyStackException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.w3c.dom.Element;

public abstract class HeadResponseWriterBase
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterBase.class);
    protected static final String ADDED_RESOURCE_TO_HEAD = "Added resource to {0}'s <head>...</head> section, element=[{1}]";
    ResponseWriter wrappedResponseWriter;
    ElementWriterStack elementWriterStack;
    private boolean titleElement = false;

    public HeadResponseWriterBase(ResponseWriter wrappedResponseWriter) {
        this.wrappedResponseWriter = wrappedResponseWriter;
        this.elementWriterStack = new ElementWriterStack();
    }

    public abstract Element createElement(String var1);

    public Writer append(CharSequence csq) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(csq);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public Writer append(char c) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(c);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(csq, start, end);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public void close() throws IOException {
        try {
            this.elementWriterStack.safePeek().close();
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void endCDATA() throws IOException {
        try {
            this.elementWriterStack.safePeek().write("]]>");
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void endDocument() throws IOException {
    }

    public void endElement(String name) throws IOException {
        if ("title".equals(name)) {
            this.titleElement = false;
        } else {
            try {
                ElementWriter elementWriter = this.elementWriterStack.pop();
                Element element = elementWriter.getElement();
                String nodeName = element.getNodeName();
                logger.trace("POPPED element name=[{0}]", new Object[]{nodeName});
                if (!"head".equals(nodeName)) {
                    this.addResourceToHeadSection(element, nodeName);
                }
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void flush() throws IOException {
        try {
            this.elementWriterStack.safePeek().flush();
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startCDATA() throws IOException {
        try {
            this.elementWriterStack.safePeek().write("<![CDATA[");
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if ("title".equals(name)) {
            logger.warn("Title removed because multiple <title> elements are invalid and the portlet container controls the <title>.");
            this.titleElement = true;
        } else {
            Element element = this.createElement(name);
            ElementWriter elementWriter = new ElementWriter(element);
            this.elementWriterStack.push(elementWriter);
            logger.trace("PUSHED element name=[{0}]", new Object[]{name});
        }
    }

    public void write(int c) throws IOException {
        try {
            this.elementWriterStack.safePeek().write(c);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf != null) {
            try {
                this.elementWriterStack.safePeek().write(cbuf);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(String str) throws IOException {
        if (str != null) {
            try {
                this.elementWriterStack.safePeek().write(str);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            try {
                this.elementWriterStack.safePeek().write(cbuf, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            try {
                this.elementWriterStack.safePeek().write(str, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        try {
            if (value == null) {
                this.elementWriterStack.safePeek().getElement().setAttribute(name, null);
            } else {
                this.elementWriterStack.safePeek().getElement().setAttribute(name, value.toString());
            }
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            try {
                this.elementWriterStack.safePeek().write(comment.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (text != null && !this.titleElement) {
            try {
                this.elementWriterStack.safePeek().write(text.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (text != null) {
            try {
                this.elementWriterStack.safePeek().write(text.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text != null) {
            try {
                this.elementWriterStack.safePeek().write(text, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (value != null) {
            value = this.escapeURI(value.toString());
        }
        this.writeAttribute(name, value, property);
    }

    protected abstract void addResourceToHeadSection(Element var1, String var2) throws IOException;

    protected String escapeURI(String uri) {
        if (uri.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            String replacement = null;
            switch (c) {
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\"': {
                    replacement = "&#034;";
                    break;
                }
                case '\'': {
                    replacement = "&#039;";
                    break;
                }
                case '\u00bb': {
                    replacement = "&#187;";
                    break;
                }
                case '\u2013': {
                    replacement = "&#x2013;";
                    break;
                }
                case '\u2014': {
                    replacement = "&#x2014;";
                }
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (i > lastReplacementIndex) {
                sb.append(uri.substring(lastReplacementIndex, i));
            }
            sb.append(replacement);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return uri;
        }
        if (lastReplacementIndex < uri.length()) {
            sb.append(uri.substring(lastReplacementIndex));
        }
        return sb.toString();
    }
}

