/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.context.internal.ExternalContextCompat_2_0_FlashImpl;
import com.liferay.faces.bridge.context.internal.RenderRedirectWriterImpl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.util.internal.FileNameUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalContextCompat_2_0_Impl
extends ExternalContextCompat_2_0_FlashImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextCompat_2_0_Impl.class);
    private static final String COOKIE_PROPERTY_COMMENT = "comment";
    private static final String COOKIE_PROPERTY_DOMAIN = "domain";
    private static final String COOKIE_PROPERTY_MAX_AGE = "maxAge";
    private static final String COOKIE_PROPERTY_PATH = "path";
    private static final String COOKIE_PROPERTY_SECURE = "secure";
    private Boolean iceFacesLegacyMode;
    private String portletContextName;
    private Boolean renderRedirectEnabled;
    private Writer responseOutputWriter;
    protected Bridge.PortletPhase portletPhase;

    public ExternalContextCompat_2_0_Impl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(portletContext, portletRequest, portletResponse);
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        Cookie cookie = this.createCookie(name, value, properties);
        this.portletResponse.addProperty(cookie);
    }

    public void addResponseHeader(String name, String value) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.addProperty(name, value);
        } else {
            logger.warn("Unable to call {0} for portletResponse=[{1}] because it is not a ResourceResponse.", new Object[]{"portletResponse.addProperty(String, String)", this.portletResponse.getClass().getName()});
        }
    }

    public String encodeBookmarkableURL(String baseURL, Map<String, List<String>> parameters) {
        if (baseURL == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL bridgeBookmarkableURL = this.bridgeURLFactory.getBridgeBookmarkableURL(facesContext, baseURL, parameters);
            return bridgeBookmarkableURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String encodePartialActionURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL bridgePartialActionURL = this.bridgeURLFactory.getBridgePartialActionURL(facesContext, url);
            return bridgePartialActionURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(facesContext, baseUrl, parameters);
            return bridgeRedirectURL.toString();
        }
        catch (BridgeException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String getContextName() {
        if (this.portletContextName == null) {
            this.portletContextName = this.portletContext.getPortletContextName();
        }
        return this.portletContextName;
    }

    public String getMimeType(String fileName) {
        String mimeType = this.portletContext.getMimeType(fileName);
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = FileNameUtil.getFileNameMimeType(fileName);
        }
        return mimeType;
    }

    public String getRealPath(String path) {
        return this.portletContext.getRealPath(path);
    }

    public int getRequestContentLength() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            int requestContentLength = clientDataRequest.getContentLength();
            if (this.manageIncongruities) {
                this.incongruityContext.setRequestContentLength(requestContentLength);
            }
            return requestContentLength;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getRequestContentLength();
        }
        throw new IllegalStateException();
    }

    public String getRequestScheme() {
        return this.portletRequest.getScheme();
    }

    public String getRequestServerName() {
        return this.portletRequest.getServerName();
    }

    public int getRequestServerPort() {
        return this.portletRequest.getServerPort();
    }

    public int getResponseBufferSize() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            int responseBufferSize = mimeResponse.getBufferSize();
            if (this.manageIncongruities) {
                this.incongruityContext.setResponseBufferSize(responseBufferSize);
            }
            return responseBufferSize;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getResponseBufferSize();
        }
        throw new IllegalStateException();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            return mimeResponse.getPortletOutputStream();
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getResponseOutputStream();
        }
        throw new IllegalStateException();
    }

    public Writer getResponseOutputWriter() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            if (this.responseOutputWriter == null) {
                MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
                if (this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                    if (this.renderRedirectEnabled == null) {
                        this.renderRedirectEnabled = PortletConfigParam.RenderRedirectEnabled.getBooleanValue(this.portletConfig);
                    }
                    this.responseOutputWriter = this.renderRedirectEnabled.booleanValue() ? new RenderRedirectWriterImpl(mimeResponse.getWriter()) : mimeResponse.getWriter();
                } else {
                    this.responseOutputWriter = mimeResponse.getWriter();
                }
            }
            return this.responseOutputWriter;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getResponseOutputWriter();
        }
        throw new IllegalStateException();
    }

    public void invalidateSession() {
        this.portletRequest.getPortletSession().invalidate();
    }

    public boolean isResponseCommitted() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            boolean responseCommitted = mimeResponse.isCommitted();
            if (this.manageIncongruities) {
                this.incongruityContext.setResponseCommitted(responseCommitted);
            }
            return responseCommitted;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.isResponseCommitted();
        }
        throw new IllegalStateException();
    }

    public void responseFlushBuffer() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            mimeResponse.flushBuffer();
        } else if (this.manageIncongruities) {
            this.incongruityContext.responseFlushBuffer();
        } else {
            throw new IllegalStateException();
        }
    }

    public void responseReset() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            mimeResponse.reset();
        } else if (this.manageIncongruities) {
            this.incongruityContext.responseReset();
        } else {
            throw new IllegalStateException();
        }
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        String errorMessage = "Status code " + statusCode + ": " + message;
        logger.error(errorMessage);
        throw new IOException(errorMessage);
    }

    public void setResponseBufferSize(int size) {
        if (this.portletResponse instanceof ResourceResponse) {
            PortalContext portalContext = this.portletRequest.getPortalContext();
            String setResponseBufferSizeSupport = portalContext.getProperty("com.liferay.faces.bridge.set.resource.response.buffer.size.support");
            if (setResponseBufferSizeSupport != null) {
                ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
                resourceResponse.setBufferSize(size);
            }
        } else if (this.manageIncongruities) {
            this.incongruityContext.setResponseBufferSize(size);
        } else {
            throw new IllegalStateException();
        }
    }

    public void setResponseContentLength(int length) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.setContentLength(length);
        } else if (this.manageIncongruities) {
            this.incongruityContext.setResponseContentLength(length);
        } else {
            throw new IllegalStateException();
        }
    }

    public void setResponseContentType(String contentType) {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            mimeResponse.setContentType(contentType);
        } else if (this.manageIncongruities) {
            this.incongruityContext.setResponseContentType(contentType);
        } else {
            throw new IllegalStateException();
        }
    }

    public void setResponseHeader(String name, String value) {
        this.addResponseHeader(name, value);
    }

    public void setResponseStatus(int statusCode) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.setProperty("portlet.http-status-code", Integer.toString(statusCode));
        } else if (this.manageIncongruities) {
            this.incongruityContext.setResponseStatus(statusCode);
        }
    }

    protected Cookie createCookie(String name, String value, Map<String, Object> properties) {
        Cookie cookie = new Cookie(name, value);
        if (properties != null && !properties.isEmpty()) {
            try {
                Boolean secure;
                String path;
                Integer maxAge;
                String domain;
                String comment = (String)properties.get(COOKIE_PROPERTY_COMMENT);
                if (comment != null) {
                    cookie.setComment(comment);
                }
                if ((domain = (String)properties.get(COOKIE_PROPERTY_DOMAIN)) != null) {
                    cookie.setDomain(domain);
                }
                if ((maxAge = (Integer)properties.get(COOKIE_PROPERTY_MAX_AGE)) != null) {
                    cookie.setMaxAge(maxAge.intValue());
                }
                if ((path = (String)properties.get(COOKIE_PROPERTY_PATH)) != null) {
                    cookie.setPath(path);
                }
                if ((secure = (Boolean)properties.get(COOKIE_PROPERTY_SECURE)) != null) {
                    cookie.setSecure(secure.booleanValue());
                }
            }
            catch (ClassCastException e) {
                logger.error(e.getMessage(), new Object[]{e});
            }
        }
        return cookie;
    }

    protected boolean isICEfacesLegacyMode(ClientDataRequest clientDataRequest) {
        if (this.iceFacesLegacyMode == null) {
            Product iceFaces;
            this.iceFacesLegacyMode = Boolean.FALSE;
            String requestContentType = clientDataRequest.getContentType();
            if (requestContentType != null && requestContentType.toLowerCase().startsWith("multipart/") && (iceFaces = ProductFactory.getProduct((Product.Name)Product.Name.ICEFACES)).isDetected() && (iceFaces.getMajorVersion() == 2 || iceFaces.getMajorVersion() == 3 && iceFaces.getMinorVersion() == 0)) {
                this.iceFacesLegacyMode = Boolean.TRUE;
            }
        }
        return this.iceFacesLegacyMode;
    }

    protected boolean isJSF2PartialRequest(FacesContext facesContext) {
        return facesContext.getPartialViewContext().isPartialRequest();
    }

    protected void partialViewContextRenderAll(FacesContext facesContext) {
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (!partialViewContext.isRenderAll()) {
            partialViewContext.setRenderAll(true);
        }
    }

    protected void redirectJSF2PartialResponse(FacesContext facesContext, ResourceResponse resourceResponse, String url) throws IOException {
        resourceResponse.setContentType("text/xml");
        resourceResponse.setCharacterEncoding("UTF-8");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        PartialResponseWriter partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : facesContext.getPartialViewContext().getPartialResponseWriter();
        partialResponseWriter.startDocument();
        partialResponseWriter.redirect(url);
        partialResponseWriter.endDocument();
        facesContext.responseComplete();
    }
}

